/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.spark.sql.MappingUtils;
import org.elasticsearch.spark.sql.Utils;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class MappingUtils$ {
    public static final MappingUtils$ MODULE$;

    static {
        new MappingUtils$();
    }

    public MappingUtils.Schema discoverMapping(Settings cfg) {
        Field field = this.discoverMappingAsField(cfg);
        StructType struct = this.convertToStruct(field, cfg);
        return new MappingUtils.Schema(field, struct);
    }

    public Field discoverMappingAsField(Settings cfg) {
        try (RestRepository repo = new RestRepository(cfg);){
            return repo.getMapping().skipHeaders();
        }
    }

    private StructType convertToStruct(Field rootField, Settings cfg) {
        StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])rootField.properties()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(Field fl) {
                return MappingUtils$.MODULE$.org$elasticsearch$spark$sql$MappingUtils$$convertField(fl);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        if (cfg.getReadMetadata()) {
            StructField metadataMap = DataTypes.createStructField((String)cfg.getReadMetadataField(), (DataType)DataTypes.createMapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, (boolean)true), (boolean)true);
            fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])fields).$colon$plus((Object)metadataMap, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        return DataTypes.createStructType((StructField[])fields);
    }

    private StructType convertToStruct(Field field) {
        return DataTypes.createStructType((StructField[])((StructField[])Predef$.MODULE$.refArrayOps((Object[])field.properties()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(Field fl) {
                return MappingUtils$.MODULE$.org$elasticsearch$spark$sql$MappingUtils$$convertField(fl);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
    }

    public StructField org$elasticsearch$spark$sql$MappingUtils$$convertField(Field field) {
        Object object;
        FieldType fieldType = Utils.extractType(field);
        FieldType fieldType2 = FieldType.NULL;
        FieldType fieldType3 = fieldType;
        if (!(fieldType2 != null ? !((Object)((Object)fieldType2)).equals((Object)fieldType3) : fieldType3 != null)) {
            object = NullType$.MODULE$;
        } else {
            FieldType fieldType4 = FieldType.BINARY;
            FieldType fieldType5 = fieldType;
            if (!(fieldType4 != null ? !((Object)((Object)fieldType4)).equals((Object)fieldType5) : fieldType5 != null)) {
                object = BinaryType$.MODULE$;
            } else {
                FieldType fieldType6 = FieldType.BOOLEAN;
                FieldType fieldType7 = fieldType;
                if (!(fieldType6 != null ? !((Object)((Object)fieldType6)).equals((Object)fieldType7) : fieldType7 != null)) {
                    object = BooleanType$.MODULE$;
                } else {
                    FieldType fieldType8 = FieldType.BYTE;
                    FieldType fieldType9 = fieldType;
                    if (!(fieldType8 != null ? !((Object)((Object)fieldType8)).equals((Object)fieldType9) : fieldType9 != null)) {
                        object = ByteType$.MODULE$;
                    } else {
                        FieldType fieldType10 = FieldType.SHORT;
                        FieldType fieldType11 = fieldType;
                        if (!(fieldType10 != null ? !((Object)((Object)fieldType10)).equals((Object)fieldType11) : fieldType11 != null)) {
                            object = ShortType$.MODULE$;
                        } else {
                            FieldType fieldType12 = FieldType.INTEGER;
                            FieldType fieldType13 = fieldType;
                            if (!(fieldType12 != null ? !((Object)((Object)fieldType12)).equals((Object)fieldType13) : fieldType13 != null)) {
                                object = IntegerType$.MODULE$;
                            } else {
                                FieldType fieldType14 = FieldType.LONG;
                                FieldType fieldType15 = fieldType;
                                if (!(fieldType14 != null ? !((Object)((Object)fieldType14)).equals((Object)fieldType15) : fieldType15 != null)) {
                                    object = LongType$.MODULE$;
                                } else {
                                    FieldType fieldType16 = FieldType.FLOAT;
                                    FieldType fieldType17 = fieldType;
                                    if (!(fieldType16 != null ? !((Object)((Object)fieldType16)).equals((Object)fieldType17) : fieldType17 != null)) {
                                        object = FloatType$.MODULE$;
                                    } else {
                                        FieldType fieldType18 = FieldType.DOUBLE;
                                        FieldType fieldType19 = fieldType;
                                        if (!(fieldType18 != null ? !((Object)((Object)fieldType18)).equals((Object)fieldType19) : fieldType19 != null)) {
                                            object = DoubleType$.MODULE$;
                                        } else {
                                            FieldType fieldType20 = FieldType.STRING;
                                            FieldType fieldType21 = fieldType;
                                            if (!(fieldType20 != null ? !((Object)((Object)fieldType20)).equals((Object)fieldType21) : fieldType21 != null)) {
                                                object = StringType$.MODULE$;
                                            } else {
                                                FieldType fieldType22 = FieldType.DATE;
                                                FieldType fieldType23 = fieldType;
                                                if (!(fieldType22 != null ? !((Object)((Object)fieldType22)).equals((Object)fieldType23) : fieldType23 != null)) {
                                                    object = TimestampType$.MODULE$;
                                                } else {
                                                    FieldType fieldType24 = FieldType.OBJECT;
                                                    FieldType fieldType25 = fieldType;
                                                    object = !(fieldType24 != null ? !((Object)((Object)fieldType24)).equals((Object)fieldType25) : fieldType25 != null) ? this.convertToStruct(field) : StringType$.MODULE$;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        NullType$ dataType = object;
        return DataTypes.createStructField((String)field.name(), (DataType)dataType, (boolean)true);
    }

    public void setRowOrder(Settings settings, StructType struct) {
        Properties rowOrder = this.detectRowOrder(settings, struct);
        settings.setProperty(Utils.ROW_ORDER_PROPERTY, IOUtils.propsToString(rowOrder));
    }

    public LinkedHashMap<String, Seq<String>> getRowOrder(Settings settings) {
        String rowOrderString = settings.getProperty(Utils.ROW_ORDER_PROPERTY);
        Assert.hasText(rowOrderString, "no schema/row order detected...");
        Properties rowOrderProps = IOUtils.propsFromString(rowOrderString);
        LinkedHashMap map = new LinkedHashMap();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowOrderProps).asScala()).foreach((Function1)new Serializable(map){
            public static final long serialVersionUID = 0L;
            private final LinkedHashMap map$1;

            public final Option<Seq<String>> apply(Tuple2<String, String> prop) {
                return this.map$1.put(prop._1(), (Object)new ArrayBuffer().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(StringUtils.tokenize((String)prop._2())).asScala()));
            }
            {
                this.map$1 = map$1;
            }
        });
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Properties detectRowOrder(Settings settings, StructType struct) {
        void var3_3;
        Properties rowOrder = new Properties();
        this.org$elasticsearch$spark$sql$MappingUtils$$doDetectOrder(rowOrder, Utils.ROOT_LEVEL_NAME, struct);
        String csv = settings.getScrollFields();
        Object object = StringUtils.hasText(csv) ? rowOrder.setProperty(Utils.ROOT_LEVEL_NAME, csv) : BoxedUnit.UNIT;
        return var3_3;
    }

    public void org$elasticsearch$spark$sql$MappingUtils$$doDetectOrder(Properties properties, String level, StructType struct) {
        ArrayList list = new ArrayList();
        struct.foreach((Function1)new Serializable(properties, list){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;
            private final ArrayList list$1;

            public final void apply(StructField field) {
                this.list$1.add(field.name());
                if (field.dataType() instanceof StructType) {
                    MappingUtils$.MODULE$.org$elasticsearch$spark$sql$MappingUtils$$doDetectOrder(this.properties$1, field.name(), (StructType)field.dataType());
                }
            }
            {
                this.properties$1 = properties$1;
                this.list$1 = list$1;
            }
        });
        properties.setProperty(level, StringUtils.concatenate(list, ","));
    }

    private MappingUtils$() {
        MODULE$ = this;
    }
}

