/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.hadoop.util.regex.Regex;

public abstract class FieldFilter {
    public static boolean filter(String path, List<String> includes, List<String> excludes) {
        includes = includes == null ? Collections.emptyList() : includes;
        List<Object> list = excludes = excludes == null ? Collections.emptyList() : excludes;
        if (includes.isEmpty() && excludes.isEmpty()) {
            return true;
        }
        if (Regex.simpleMatch(excludes, path)) {
            return false;
        }
        boolean exactIncludeMatch = false;
        boolean pathIsPrefixOfAnInclude = false;
        if (includes.isEmpty()) {
            exactIncludeMatch = true;
        } else {
            for (String include : includes) {
                if (include.charAt(0) == '*') {
                    if (Regex.simpleMatch(include, path)) {
                        exactIncludeMatch = true;
                        break;
                    }
                    pathIsPrefixOfAnInclude = true;
                    continue;
                }
                if (include.startsWith(path)) {
                    if (include.length() == path.length()) {
                        exactIncludeMatch = true;
                        break;
                    }
                    if (include.length() > path.length() && include.charAt(path.length()) == '.') {
                        pathIsPrefixOfAnInclude = true;
                        continue;
                    }
                }
                if (!Regex.simpleMatch(include, path)) continue;
                exactIncludeMatch = true;
                break;
            }
        }
        if (!pathIsPrefixOfAnInclude && !exactIncludeMatch) {
            return false;
        }
        if (exactIncludeMatch) {
            return true;
        }
        return true;
    }
}

