/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.serialization.bulk.BulkFactory;
import org.elasticsearch.hadoop.serialization.bulk.JsonScriptTemplateBulk;
import org.elasticsearch.hadoop.serialization.bulk.JsonTemplatedBulk;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.bulk.RawJson;
import org.elasticsearch.hadoop.serialization.bulk.ScriptTemplateBulk;
import org.elasticsearch.hadoop.serialization.bulk.TemplatedBulk;
import org.elasticsearch.hadoop.serialization.field.FieldExplainer;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.serialization.field.IndexExtractor;
import org.elasticsearch.hadoop.serialization.field.JsonFieldExtractors;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.BytesArrayPool;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class AbstractBulkFactory
implements BulkFactory {
    private static Log log = LogFactory.getLog(AbstractBulkFactory.class);
    protected Settings settings;
    private final boolean jsonInput;
    private final boolean isStatic;
    private final MetadataExtractor metaExtractor;
    private IndexExtractor indexExtractor;
    private FieldExtractor idExtractor;
    private FieldExtractor typeExtractor;
    private FieldExtractor parentExtractor;
    private FieldExtractor routingExtractor;
    private FieldExtractor versionExtractor;
    private FieldExtractor ttlExtractor;
    private FieldExtractor timestampExtractor;
    private FieldExtractor paramsExtractor;
    private final FieldExtractor versionTypeExtractor = new FieldExtractor(){
        private Object value;

        @Override
        public Object field(Object target) {
            if (this.value == null) {
                this.value = new RawJson(StringUtils.toJsonString(AbstractBulkFactory.this.settings.getMappingVersionType()));
            }
            return this.value;
        }
    };
    private JsonFieldExtractors jsonExtractors;
    private final ValueWriter valueWriter;

    AbstractBulkFactory(Settings settings, MetadataExtractor metaExtractor) {
        this.settings = settings;
        this.valueWriter = (ValueWriter)ObjectUtils.instantiate(settings.getSerializerValueWriterClassName(), settings);
        this.metaExtractor = metaExtractor;
        this.jsonInput = settings.getInputAsJson();
        this.isStatic = metaExtractor == null;
        this.initExtractorsFromSettings(settings);
    }

    private void initExtractorsFromSettings(final Settings settings) {
        if (this.jsonInput) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"JSON input; using internal field extractor for efficient parsing...");
            }
            this.jsonExtractors = new JsonFieldExtractors(settings);
            this.indexExtractor = this.jsonExtractors.indexAndType();
            this.idExtractor = this.jsonExtractors.id();
            this.parentExtractor = this.jsonExtractors.parent();
            this.routingExtractor = this.jsonExtractors.routing();
            this.versionExtractor = this.jsonExtractors.version();
            this.ttlExtractor = this.jsonExtractors.ttl();
            this.timestampExtractor = this.jsonExtractors.timestamp();
            this.paramsExtractor = this.jsonExtractors.params();
        } else {
            if (settings.getMappingId() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingId());
                this.idExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingIdExtractorClassName(), settings);
            }
            if (settings.getMappingParent() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingParent());
                this.parentExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingParentExtractorClassName(), settings);
            }
            if (settings.getMappingRouting() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingRouting());
                this.routingExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingRoutingExtractorClassName(), settings);
            }
            if (settings.getMappingTtl() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingTtl());
                this.ttlExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingTtlExtractorClassName(), settings);
            }
            if (settings.getMappingVersion() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingVersion());
                this.versionExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingVersionExtractorClassName(), settings);
            }
            if (settings.getMappingTimestamp() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingTimestamp());
                this.timestampExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingTimestampExtractorClassName(), settings);
            }
            IndexExtractor iformat = (IndexExtractor)ObjectUtils.instantiate(settings.getMappingIndexExtractorClassName(), settings);
            iformat.compile(new Resource(settings, false).toString());
            if (iformat.hasPattern()) {
                this.indexExtractor = iformat;
            }
            if (settings.hasUpdateScriptParams()) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getUpdateScriptParams());
                this.paramsExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingParamsExtractorClassName(), settings);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Instantiated value writer [%s]", this.valueWriter));
                if (this.idExtractor != null) {
                    log.trace((Object)String.format("Instantiated id extractor [%s]", this.idExtractor));
                }
                if (this.parentExtractor != null) {
                    log.trace((Object)String.format("Instantiated parent extractor [%s]", this.parentExtractor));
                }
                if (this.routingExtractor != null) {
                    log.trace((Object)String.format("Instantiated routing extractor [%s]", this.routingExtractor));
                }
                if (this.ttlExtractor != null) {
                    log.trace((Object)String.format("Instantiated ttl extractor [%s]", this.ttlExtractor));
                }
                if (this.versionExtractor != null) {
                    log.trace((Object)String.format("Instantiated version extractor [%s]", this.versionExtractor));
                }
                if (this.timestampExtractor != null) {
                    log.trace((Object)String.format("Instantiated timestamp extractor [%s]", this.timestampExtractor));
                }
                if (this.paramsExtractor != null) {
                    log.trace((Object)String.format("Instantiated params extractor [%s]", this.paramsExtractor));
                }
            }
        }
        if (settings.hasUpdateScriptParamsJson()) {
            this.paramsExtractor = new FieldExtractor(){

                @Override
                public Object field(Object target) {
                    return new RawJson(settings.getUpdateScriptParamsJson().trim());
                }
            };
        }
    }

    @Override
    public BulkCommand createBulk() {
        List<Object> before = new ArrayList<Object>();
        List<Object> after = new ArrayList<Object>();
        if (!this.isStatic) {
            before.add(new DynamicHeaderRef());
            after.add(new DynamicEndRef());
        } else {
            this.writeObjectHeader(before);
            before = this.compact(before);
            this.writeObjectEnd(after);
            after = this.compact(after);
        }
        boolean isScriptUpdate = this.settings.hasUpdateScript();
        if (this.jsonInput) {
            if (isScriptUpdate) {
                return new JsonScriptTemplateBulk(before, after, this.jsonExtractors, this.settings);
            }
            return new JsonTemplatedBulk(before, after, this.jsonExtractors, this.settings);
        }
        if (isScriptUpdate) {
            return new ScriptTemplateBulk(this.settings, before, after, this.valueWriter);
        }
        return new TemplatedBulk(before, after, this.valueWriter);
    }

    protected void writeObjectHeader(List<Object> list) {
        list.add("{\"" + this.getOperation() + "\":{");
        boolean commaMightBeNeeded = false;
        commaMightBeNeeded = this.addExtractorOrDynamicValue(list, this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.INDEX, this.indexExtractor), "", commaMightBeNeeded);
        commaMightBeNeeded = this.addExtractorOrDynamicValue(list, this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.TYPE, this.typeExtractor), "\"_type\":", commaMightBeNeeded);
        commaMightBeNeeded = this.id(list, commaMightBeNeeded);
        commaMightBeNeeded = this.addExtractorOrDynamicValue(list, this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.PARENT, this.parentExtractor), "\"_parent\":", commaMightBeNeeded);
        commaMightBeNeeded = this.addExtractorOrDynamicValue(list, this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.ROUTING, this.routingExtractor), "\"_routing\":", commaMightBeNeeded);
        commaMightBeNeeded = this.addExtractorOrDynamicValue(list, this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.TTL, this.ttlExtractor), "\"_ttl\":", commaMightBeNeeded);
        commaMightBeNeeded = this.addExtractorOrDynamicValue(list, this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.TIMESTAMP, this.timestampExtractor), "\"_timestamp\":", commaMightBeNeeded);
        Object versionField = this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.VERSION, this.versionExtractor);
        if (versionField != null) {
            if (commaMightBeNeeded) {
                list.add(",");
                commaMightBeNeeded = false;
            }
            commaMightBeNeeded = true;
            list.add("\"_version\":");
            list.add(versionField);
            Object versionTypeField = this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.VERSION_TYPE, this.versionTypeExtractor);
            if (versionTypeField != null) {
                if (commaMightBeNeeded) {
                    list.add(",");
                    commaMightBeNeeded = false;
                }
                commaMightBeNeeded = true;
                list.add("\"_version_type\":");
                list.add(versionTypeField);
            }
        }
        this.otherHeader(list, commaMightBeNeeded);
        list.add("}}\n");
    }

    protected boolean id(List<Object> list, boolean commaMightBeNeeded) {
        return this.addExtractorOrDynamicValue(list, this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.ID, this.idExtractor), "\"_id\":", commaMightBeNeeded);
    }

    private boolean addExtractorOrDynamicValue(List<Object> list, Object extractor, String header, boolean commaMightBeNeeded) {
        if (extractor != null) {
            if (commaMightBeNeeded) {
                list.add(",");
            }
            list.add(header);
            list.add(extractor);
            return true;
        }
        return commaMightBeNeeded;
    }

    protected void otherHeader(List<Object> list, boolean commaMightBeNeeded) {
    }

    protected Object getExtractorOrDynamicValue(MetadataExtractor.Metadata meta, FieldExtractor fallbackExtractor) {
        FieldExtractor metaFE;
        if (this.metaExtractor != null && (metaFE = this.metaExtractor.get(meta)) != null) {
            return metaFE;
        }
        return fallbackExtractor;
    }

    protected abstract String getOperation();

    protected void writeObjectEnd(List<Object> list) {
        list.add("\n");
    }

    private List<Object> compact(List<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<Object> compacted = new ArrayList<Object>();
        StringBuilder stringAccumulator = new StringBuilder();
        for (Object object : list) {
            if (object instanceof FieldExtractor) {
                if (stringAccumulator.length() > 0) {
                    compacted.add(new BytesArray(stringAccumulator.toString()));
                    stringAccumulator.setLength(0);
                }
                compacted.add(new FieldWriter((FieldExtractor)object));
                continue;
            }
            stringAccumulator.append(object.toString());
        }
        if (stringAccumulator.length() > 0) {
            compacted.add(new BytesArray(stringAccumulator.toString()));
        }
        return compacted;
    }

    protected FieldExtractor getParamExtractor() {
        return this.paramsExtractor;
    }

    class DynamicFieldExtractor
    implements FieldExtractor {
        private final List<Object> before = new ArrayList<Object>();

        DynamicFieldExtractor() {
        }

        @Override
        public Object field(Object target) {
            this.before.clear();
            AbstractBulkFactory.this.writeObjectHeader(this.before);
            return AbstractBulkFactory.this.compact(this.before);
        }
    }

    public class DynamicEndRef
    implements DynamicContentRef {
        final List<Object> end = new ArrayList<Object>();

        @Override
        public List<Object> getDynamicContent() {
            this.end.clear();
            AbstractBulkFactory.this.writeObjectEnd(this.end);
            return AbstractBulkFactory.this.compact(this.end);
        }
    }

    public class DynamicHeaderRef
    implements DynamicContentRef {
        final List<Object> header = new ArrayList<Object>();

        @Override
        public List<Object> getDynamicContent() {
            this.header.clear();
            AbstractBulkFactory.this.writeObjectHeader(this.header);
            return AbstractBulkFactory.this.compact(this.header);
        }
    }

    static interface DynamicContentRef {
        public List<Object> getDynamicContent();
    }

    class FieldWriter {
        final FieldExtractor extractor;
        final BytesArrayPool pool = new BytesArrayPool();

        FieldWriter(FieldExtractor extractor) {
            this.extractor = extractor;
        }

        BytesArrayPool write(Object object) {
            this.pool.reset();
            Object value = this.extractor.field(object);
            if (value == FieldExtractor.NOT_FOUND) {
                String obj = this.extractor instanceof FieldExplainer ? ((FieldExplainer)((Object)this.extractor)).toString(object) : object.toString();
                throw new EsHadoopIllegalArgumentException(String.format("[%s] cannot extract value from entity [%s] | instance [%s]", this.extractor, obj.getClass(), obj));
            }
            if (value instanceof List) {
                for (Object val : (List)value) {
                    this.doWrite(val);
                }
            } else {
                this.doWrite(value);
            }
            return this.pool;
        }

        void doWrite(Object value) {
            if (value instanceof String || AbstractBulkFactory.this.jsonInput || value instanceof Number || value == null) {
                String valueString;
                String string = valueString = value == null ? "null" : value.toString();
                if (value instanceof String && !AbstractBulkFactory.this.jsonInput) {
                    valueString = StringUtils.toJsonString(valueString);
                }
                this.pool.get().bytes(valueString);
            } else if (value instanceof RawJson) {
                this.pool.get().bytes(((RawJson)value).json());
            } else {
                BytesArray ba = this.pool.get();
                JacksonJsonGenerator generator = new JacksonJsonGenerator(new FastByteArrayOutputStream(ba));
                AbstractBulkFactory.this.valueWriter.write(value, generator);
                generator.flush();
                generator.close();
            }
        }

        public String toString() {
            return "FieldWriter for " + this.extractor;
        }
    }
}

