/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class ScrollReader {
    private static final Log log = LogFactory.getLog(ScrollReader.class);
    private Parser parser;
    private final ValueReader reader;
    private final Map<String, FieldType> esMapping;
    private final boolean trace = log.isTraceEnabled();
    private final boolean readMetadata;
    private final String metadataField;
    private final boolean returnRawJson;
    private static final String[] HITS = new String[]{"hits"};
    private static final String[] ID = new String[]{"_id"};
    private static final String[] FIELDS = new String[]{"fields"};
    private static final String[] SOURCE = new String[]{"_source"};
    private static final String[] TOTAL = new String[]{"hits", "total"};

    public ScrollReader(ValueReader reader, Field rootField, boolean readMetadata, String metadataName, boolean returnRawJson) {
        this.reader = reader;
        this.esMapping = Field.toLookupMap(rootField);
        this.readMetadata = readMetadata;
        this.metadataField = metadataName;
        this.returnRawJson = returnRawJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> read(InputStream content) throws IOException {
        Assert.notNull(content);
        BytesArray copy = null;
        if (log.isTraceEnabled() || this.returnRawJson) {
            copy = IOUtils.asBytes(content);
            content = new FastByteArrayInputStream(copy);
            log.trace((Object)("About to parse scroll content " + copy));
        }
        this.parser = new JacksonJsonParser(content);
        try {
            List<Object[]> list = this.read(copy);
            return list;
        }
        finally {
            this.parser.close();
        }
    }

    private List<Object[]> read(BytesArray input) {
        if (this.hits() == 0L) {
            return null;
        }
        Parser.Token token = ParsingUtils.seek(this.parser, HITS);
        Assert.isTrue(token == Parser.Token.START_ARRAY, "invalid response");
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        token = this.parser.nextToken();
        while (token != Parser.Token.END_ARRAY) {
            results.add(this.readHit());
            token = this.parser.nextToken();
        }
        if (this.returnRawJson) {
            int[] pos = new int[results.size() * 6];
            int offset = 0;
            ArrayList<int[]> fragmentsPos = new ArrayList<int[]>(results.size());
            for (Object[] result : results) {
                int[] asCharPos = ((JsonResult)result[1]).asCharPos();
                fragmentsPos.add(asCharPos);
                System.arraycopy(asCharPos, 0, pos, offset, asCharPos.length);
                offset += asCharPos.length;
            }
            int[] bytesPosition = pos;
            int bytesPositionIndex = 0;
            BytesArray doc = new BytesArray(128);
            for (int fragmentIndex = 0; fragmentIndex < fragmentsPos.size(); ++fragmentIndex) {
                int rangeStart;
                int rangeStop;
                Object[] result = (Object[])results.get(fragmentIndex);
                JsonResult jsonPointers = (JsonResult)result[1];
                int[] fragmentPos = (int[])fragmentsPos.get(fragmentIndex);
                int currentFragmentIndex = 0;
                doc.add(123);
                if (jsonPointers.hasDoc()) {
                    rangeStop = bytesPosition[bytesPositionIndex + 1];
                    rangeStart = bytesPosition[bytesPositionIndex];
                    if (rangeStop - rangeStart < 0) {
                        throw new IllegalArgumentException(String.format("Invalid position given=%s %s", rangeStart, rangeStop));
                    }
                    doc.add(input.bytes(), rangeStart, rangeStop - rangeStart);
                    currentFragmentIndex += 2;
                    bytesPositionIndex += 2;
                }
                if (this.readMetadata) {
                    if (jsonPointers.hasDoc()) {
                        doc.add(44);
                    }
                    doc.add(34);
                    doc.add(StringUtils.jsonEncoding(this.metadataField));
                    doc.add(34);
                    doc.add(58);
                    doc.add(123);
                    while (currentFragmentIndex < fragmentPos.length) {
                        rangeStop = bytesPosition[bytesPositionIndex + 1];
                        rangeStart = bytesPosition[bytesPositionIndex];
                        if (rangeStop - rangeStart < 0) {
                            throw new IllegalArgumentException(String.format("Invalid position given=%s %s", rangeStart, rangeStop));
                        }
                        doc.add(input.bytes(), rangeStart, rangeStop - rangeStart);
                        bytesPositionIndex += 2;
                        currentFragmentIndex += 2;
                    }
                    doc.add(125);
                }
                doc.add(125);
                result[1] = this.reader.wrapString(doc.toString());
                doc.reset();
            }
        }
        return results;
    }

    private Object[] readHit() {
        Parser.Token t = this.parser.currentToken();
        Assert.isTrue(t == Parser.Token.START_OBJECT, "expected object, found " + (Object)((Object)t));
        return this.returnRawJson ? this.readHitAsJson() : this.readHitAsMap();
    }

    private Object[] readHitAsMap() {
        Object[] result = new Object[2];
        Object metadata = null;
        Object id = null;
        Parser.Token t = this.parser.currentToken();
        if (this.readMetadata) {
            result[1] = metadata = this.reader.createMap();
            t = this.parser.nextToken();
            while ((t = this.parser.currentToken()) != null) {
                String name = this.parser.currentName();
                Object value = null;
                if (t == Parser.Token.FIELD_NAME && !"fields".equals(name) && !"_source".equals(name)) {
                    value = this.read(this.parser.nextToken(), null);
                    if ("_id".equals(name)) {
                        id = value;
                    }
                    this.reader.addToMap(metadata, this.reader.wrapString(name), value);
                    continue;
                }
                t = t != Parser.Token.FIELD_NAME ? null : this.parser.nextToken();
                break;
            }
            Assert.notNull(id, "no id found");
            result[0] = id;
        } else {
            Assert.notNull((Object)ParsingUtils.seek(this.parser, ID), "no id found");
            result[0] = this.reader.wrapString(this.parser.text());
            t = ParsingUtils.seek(this.parser, SOURCE, FIELDS);
        }
        Object data = Collections.emptyMap();
        if (t != null) {
            data = this.read(t, null);
            if (this.readMetadata) {
                this.reader.addToMap(data, this.reader.wrapString(this.metadataField), metadata);
            }
        } else if (this.readMetadata) {
            data = this.reader.createMap();
            this.reader.addToMap(data, this.reader.wrapString(this.metadataField), metadata);
        }
        result[1] = data;
        while (this.parser.currentToken() == Parser.Token.FIELD_NAME) {
            String name = this.parser.currentName();
            if (this.readMetadata) {
                this.reader.addToMap(data, this.reader.wrapString(name), this.read(this.parser.nextToken(), null));
                continue;
            }
            this.parser.nextToken();
            this.parser.skipChildren();
            this.parser.nextToken();
        }
        if (this.trace) {
            log.trace((Object)String.format("Read hit result [%s]", result));
        }
        return result;
    }

    private Object[] readHitAsJson() {
        Object[] result = new Object[2];
        Object id = null;
        Parser.Token t = this.parser.currentToken();
        JsonResult snippet = new JsonResult();
        if (this.readMetadata) {
            result[1] = snippet;
            t = this.parser.nextToken();
            int metadataStartChar = this.parser.tokenCharOffset();
            int metadataStopChar = -1;
            int endCharOfLastElement = -1;
            while ((t = this.parser.currentToken()) != null) {
                String name = this.parser.currentName();
                if (t == Parser.Token.FIELD_NAME) {
                    if ("_id".equals(name)) {
                        t = this.parser.nextToken();
                        id = this.reader.wrapString(this.parser.text());
                        endCharOfLastElement = this.parser.tokenCharOffset();
                        t = this.parser.nextToken();
                        continue;
                    }
                    if ("fields".equals(name) || "_source".equals(name)) {
                        metadataStopChar = endCharOfLastElement;
                        t = this.parser.nextToken();
                        break;
                    }
                    this.parser.skipChildren();
                    this.parser.nextToken();
                    t = this.parser.nextToken();
                    endCharOfLastElement = this.parser.tokenCharOffset();
                    continue;
                }
                metadataStopChar = endCharOfLastElement;
                t = null;
                break;
            }
            Assert.notNull(id, "no id found");
            result[0] = id;
            if (metadataStartChar >= 0 && metadataStopChar >= 0) {
                snippet.addMetadata(new JsonFragment(metadataStartChar, metadataStopChar));
            }
        } else {
            Assert.notNull((Object)ParsingUtils.seek(this.parser, ID), "no id found");
            result[0] = this.reader.wrapString(this.parser.text());
            t = ParsingUtils.seek(this.parser, SOURCE, FIELDS);
        }
        if (t != null) {
            t = this.parser.nextToken();
            int charStart = this.parser.tokenCharOffset();
            this.skipCurrentBlock();
            int charStop = this.parser.tokenCharOffset();
            t = this.parser.nextToken();
            snippet.addDoc(new JsonFragment(charStart, charStop));
        }
        int metadataSuffixStartCharPos = this.parser.tokenCharOffset();
        int metadataSuffixStopCharPos = -1;
        while ((t = this.parser.currentToken()) == Parser.Token.FIELD_NAME) {
            t = this.parser.nextToken();
            this.skipCurrentBlock();
            t = this.parser.nextToken();
            if (!this.readMetadata) continue;
            metadataSuffixStopCharPos = this.parser.tokenCharOffset();
        }
        if (this.readMetadata && metadataSuffixStartCharPos >= 0 && metadataSuffixStopCharPos >= 0) {
            snippet.addMetadata(new JsonFragment(metadataSuffixStartCharPos, metadataSuffixStopCharPos));
        }
        result[1] = snippet;
        if (this.trace) {
            log.trace((Object)String.format("Read hit result [%s]", result));
        }
        return result;
    }

    private void skipCurrentBlock() {
        int open = 1;
        Parser.Token t;
        while ((t = this.parser.nextToken()) != null) {
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++open;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--open != 0) break;
                    return;
                }
            }
        }
        return;
    }

    private long hits() {
        ParsingUtils.seek(this.parser, TOTAL);
        long hits = this.parser.longValue();
        return hits;
    }

    protected Object read(Parser.Token t, String fieldMapping) {
        if (t == Parser.Token.START_OBJECT) {
            return this.map(fieldMapping);
        }
        if (t == Parser.Token.START_ARRAY) {
            return this.list(fieldMapping);
        }
        FieldType esType = this.mapping(fieldMapping);
        if (t.isValue()) {
            return this.parseValue(esType);
        }
        return null;
    }

    private Object parseValue(FieldType esType) {
        Object obj = this.parser.currentToken() == Parser.Token.VALUE_NULL ? null : this.reader.readValue(this.parser, this.parser.text(), esType);
        this.parser.nextToken();
        return obj;
    }

    protected Object list(String fieldMapping) {
        Parser.Token t = this.parser.currentToken();
        if (t == null) {
            t = this.parser.nextToken();
        }
        if (t == Parser.Token.START_ARRAY) {
            t = this.parser.nextToken();
        }
        Object array = this.reader.createArray(this.mapping(fieldMapping));
        ArrayList<Object> content = new ArrayList<Object>(1);
        while (this.parser.currentToken() != Parser.Token.END_ARRAY) {
            content.add(this.read(this.parser.currentToken(), fieldMapping));
        }
        this.parser.nextToken();
        array = this.reader.addToArray(array, content);
        return array;
    }

    protected Object map(String fieldMapping) {
        Parser.Token t = this.parser.currentToken();
        if (t == null) {
            t = this.parser.nextToken();
        }
        if (t == Parser.Token.START_OBJECT) {
            t = this.parser.nextToken();
        }
        Object map = this.reader.createMap();
        while (this.parser.currentToken() != Parser.Token.END_OBJECT) {
            String currentName = this.parser.currentName();
            String nodeMapping = fieldMapping;
            nodeMapping = nodeMapping != null ? fieldMapping + "." + currentName : currentName;
            Object fieldName = this.reader.readValue(this.parser, currentName, FieldType.STRING);
            this.reader.addToMap(map, fieldName, this.read(this.parser.nextToken(), nodeMapping));
        }
        this.parser.nextToken();
        return map;
    }

    private FieldType mapping(String fieldMapping) {
        FieldType esType = this.esMapping.get(fieldMapping);
        if (esType != null) {
            return esType;
        }
        Parser.Token currentToken = this.parser.currentToken();
        if (!currentToken.isValue()) {
            return FieldType.OBJECT;
        }
        block0 : switch (currentToken) {
            case VALUE_NULL: {
                esType = FieldType.NULL;
                break;
            }
            case VALUE_BOOLEAN: {
                esType = FieldType.BOOLEAN;
                break;
            }
            case VALUE_STRING: {
                esType = FieldType.STRING;
                break;
            }
            case VALUE_NUMBER: {
                Parser.NumberType numberType = this.parser.numberType();
                switch (numberType) {
                    case INT: {
                        esType = FieldType.INTEGER;
                        break block0;
                    }
                    case LONG: {
                        esType = FieldType.LONG;
                        break block0;
                    }
                    case FLOAT: {
                        esType = FieldType.FLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        esType = FieldType.DOUBLE;
                        break block0;
                    }
                    case BIG_DECIMAL: {
                        throw new UnsupportedOperationException();
                    }
                    case BIG_INTEGER: {
                        throw new UnsupportedOperationException();
                    }
                }
                break;
            }
        }
        return esType;
    }

    private static class JsonResult {
        private JsonFragment doc = JsonFragment.EMPTY;
        private final List<JsonFragment> fragments = new ArrayList<JsonFragment>(2);

        private JsonResult() {
        }

        void addMetadata(JsonFragment fragment) {
            if (fragment != null && fragment.isValid()) {
                this.fragments.add(fragment);
            }
        }

        void addDoc(JsonFragment fragment) {
            if (fragment != null && fragment.isValid()) {
                this.doc = fragment;
            }
        }

        boolean hasDoc() {
            return this.doc.isValid();
        }

        int[] asCharPos() {
            int positions = this.fragments.size() << 1;
            if (this.doc.isValid()) {
                positions += 2;
            }
            int[] pos = new int[positions];
            int index = 0;
            if (this.doc.isValid()) {
                pos[index++] = this.doc.charStart;
                pos[index++] = this.doc.charStop;
            }
            for (JsonFragment fragment : this.fragments) {
                pos[index++] = fragment.charStart;
                pos[index++] = fragment.charStop;
            }
            return pos;
        }

        public String toString() {
            return "doc=" + this.doc + "metadata=" + this.fragments;
        }
    }

    private static class JsonFragment {
        static final JsonFragment EMPTY = new JsonFragment(-1, -1){

            @Override
            public String toString() {
                return "Empty";
            }
        };
        final int charStart;
        final int charStop;

        JsonFragment(int charStart, int charStop) {
            this.charStart = charStart;
            this.charStop = charStop;
        }

        boolean isValid() {
            return this.charStart >= 0 && this.charStop >= 0;
        }

        public String toString() {
            return "[" + this.charStart + "," + this.charStop + "]";
        }
    }
}

