/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.EsHadoopInvalidRequest;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.ShardSorter;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommands;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.dto.Node;
import org.elasticsearch.hadoop.serialization.dto.Shard;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.BytesRef;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.TrackingBytesArray;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class RestRepository
implements Closeable,
StatsAware {
    private static Log log = LogFactory.getLog(RestRepository.class);
    private static final BitSet EMPTY = new BitSet();
    private int bufferEntriesThreshold;
    private final BytesArray ba = new BytesArray(0);
    private final TrackingBytesArray data = new TrackingBytesArray(this.ba);
    private int dataEntries = 0;
    private boolean requiresRefreshAfterBulk = false;
    private boolean executedBulkWrite = false;
    private BytesRef trivialBytesRef;
    private boolean writeInitialized = false;
    private boolean autoFlush = true;
    private boolean hadWriteErrors = false;
    private RestClient client;
    private Resource resourceR;
    private Resource resourceW;
    private BulkCommand command;
    private MetadataExtractor metaExtractor;
    private final Settings settings;
    private final Stats stats = new Stats();

    public RestRepository(Settings settings) {
        this.settings = settings;
        if (StringUtils.hasText(settings.getResourceRead())) {
            this.resourceR = new Resource(settings, true);
        }
        if (StringUtils.hasText(settings.getResourceWrite())) {
            this.resourceW = new Resource(settings, false);
        }
        Assert.isTrue(this.resourceR != null || this.resourceW != null, "Invalid configuration - No read or write resource specified");
        this.client = new RestClient(settings);
    }

    private void lazyInitWriting() {
        if (!this.writeInitialized) {
            this.writeInitialized = true;
            this.autoFlush = !this.settings.getBatchFlushManual();
            this.ba.bytes(new byte[this.settings.getBatchSizeInBytes()], 0);
            this.trivialBytesRef = new BytesRef();
            this.bufferEntriesThreshold = this.settings.getBatchSizeInEntries();
            this.requiresRefreshAfterBulk = this.settings.getBatchRefreshAfterWrite();
            this.command = BulkCommands.create(this.settings, this.metaExtractor);
        }
    }

    ScrollQuery scan(String query, BytesArray body, ScrollReader reader) {
        String[] scrollInfo = this.client.scan(query, body);
        String scrollId = scrollInfo[0];
        long totalSize = Long.parseLong(scrollInfo[1]);
        return new ScrollQuery(this, scrollId, totalSize, reader);
    }

    public void addRuntimeFieldExtractor(MetadataExtractor metaExtractor) {
        this.metaExtractor = metaExtractor;
    }

    public void writeToIndex(Object object) {
        Assert.notNull(object, "no object data given");
        this.lazyInitWriting();
        this.doWriteToIndex(this.command.write(object));
    }

    public void writeProcessedToIndex(BytesArray ba) {
        Assert.notNull(ba, "no data given");
        Assert.isTrue(ba.length() > 0, "no data given");
        this.lazyInitWriting();
        this.trivialBytesRef.reset();
        this.trivialBytesRef.add(ba);
        this.doWriteToIndex(this.trivialBytesRef);
    }

    private void doWriteToIndex(BytesRef payload) {
        if (payload.length() > this.ba.available()) {
            if (this.autoFlush) {
                this.flush();
            } else {
                throw new EsHadoopIllegalStateException(String.format("Auto-flush disabled and bulk buffer full; disable manual flush or increase capacity [current size %s]; bailing out", this.ba.capacity()));
            }
        }
        this.data.copyFrom(payload);
        payload.reset();
        ++this.dataEntries;
        if (this.bufferEntriesThreshold > 0 && this.dataEntries >= this.bufferEntriesThreshold) {
            if (this.autoFlush) {
                this.flush();
            } else if (this.dataEntries > this.bufferEntriesThreshold) {
                throw new EsHadoopIllegalStateException(String.format("Auto-flush disabled and maximum number of entries surpassed; disable manual flush or increase capacity [current size %s]; bailing out", this.bufferEntriesThreshold));
            }
        }
    }

    public BitSet tryFlush() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending batch of [%d] bytes/[%s] entries", this.data.length(), this.dataEntries));
        }
        BitSet bulkResult = EMPTY;
        try {
            if (this.data.length() > 0) {
                bulkResult = this.client.bulk(this.resourceW, this.data);
                this.executedBulkWrite = true;
            }
        }
        catch (EsHadoopException ex) {
            this.hadWriteErrors = true;
            throw ex;
        }
        this.discard();
        return bulkResult;
    }

    public void discard() {
        this.data.reset();
        this.dataEntries = 0;
    }

    public void flush() {
        BitSet bulk = this.tryFlush();
        if (!bulk.isEmpty()) {
            throw new EsHadoopException(String.format("Could not write all entries [%s/%s] (maybe ES was overloaded?). Bailing out...", bulk.cardinality(), bulk.size()));
        }
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing repository and connection to Elasticsearch ...");
        }
        if (!this.hadWriteErrors) {
            this.flush();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Dirty close; ignoring last existing write batch...");
        }
        if (this.requiresRefreshAfterBulk && this.executedBulkWrite) {
            this.client.refresh(this.resourceW);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Refreshing index [%s]", this.resourceW));
            }
        }
        if (this.client != null) {
            this.client.close();
            this.stats.aggregate(this.client.stats());
            this.client = null;
        }
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public Object[] getReadTargetShards(boolean clientNodesOnly) {
        for (int retries = 0; retries < 3; ++retries) {
            Object[] result = this.doGetReadTargetShards(clientNodesOnly);
            if (result == null) continue;
            return result;
        }
        throw new EsHadoopIllegalStateException("Cluster state volatile; cannot find node backing shards - please check whether your cluster is stable");
    }

    protected Object[] doGetReadTargetShards(boolean clientNodesOnly) {
        List<List<Map<String, Object>>> info = this.client.targetShards(this.resourceR.index());
        Map<String, Node> httpNodes = this.client.getHttpNodes(clientNodesOnly);
        if (httpNodes.isEmpty()) {
            String msg = "No HTTP-enabled data nodes found";
            if (!this.settings.getNodesClientOnly()) {
                msg = msg + String.format("; if you are using client-only nodes make sure to configure es-hadoop as such through [%s] property", "es.nodes.client.only");
            }
            new EsHadoopIllegalStateException(msg);
        }
        LinkedHashMap<Shard, Node> shards = new LinkedHashMap<Shard, Node>();
        boolean overlappingShards = false;
        Object[] result = new Object[]{overlappingShards, shards};
        if (!this.isReadIndexConcrete()) {
            String message = String.format("Read resource [%s] includes multiple indices or/and aliases; to avoid duplicate results (caused by shard overlapping), parallelism ", this.resourceR);
            Map<Shard, Node> combination = ShardSorter.find(info, httpNodes, log);
            if (combination.isEmpty()) {
                message = message + "is minimized";
                log.warn((Object)message);
                overlappingShards = true;
                result[0] = overlappingShards;
            } else {
                int initialParallelism = 0;
                for (List<Map<String, Object>> shardGroup : info) {
                    initialParallelism += shardGroup.size();
                }
                if (initialParallelism > combination.size()) {
                    message = message + String.format("is reduced from %s to %s", initialParallelism, combination.size());
                    log.warn((Object)message);
                }
                result[0] = overlappingShards;
                result[1] = combination;
                return result;
            }
        }
        LinkedHashSet<Integer> seenShards = new LinkedHashSet<Integer>();
        block1: for (List<Map<String, Object>> shardGroup : info) {
            for (Map<String, Object> shardData : shardGroup) {
                Shard shard = new Shard(shardData);
                if (!shard.getState().isStarted()) continue;
                Node node = httpNodes.get(shard.getNode());
                if (node == null) {
                    log.warn((Object)String.format("Cannot find node with id [%s] (is HTTP enabled?) from shard [%s] in nodes [%s]; layout [%s]", shard.getNode(), shard, httpNodes, info));
                    return null;
                }
                if (overlappingShards) {
                    if (!seenShards.add(shard.getName())) continue;
                    shards.put(shard, node);
                    continue;
                }
                shards.put(shard, node);
                continue block1;
            }
        }
        return result;
    }

    public Map<Shard, Node> getWriteTargetPrimaryShards(boolean clientNodesOnly) {
        for (int retries = 0; retries < 3; ++retries) {
            Map<Shard, Node> map = this.doGetWriteTargetPrimaryShards(clientNodesOnly);
            if (map == null) continue;
            return map;
        }
        throw new EsHadoopIllegalStateException("Cluster state volatile; cannot find node backing shards - please check whether your cluster is stable");
    }

    protected Map<Shard, Node> doGetWriteTargetPrimaryShards(boolean clientNodesOnly) {
        List<List<Map<String, Object>>> info = this.client.targetShards(this.resourceW.index());
        LinkedHashMap<Shard, Node> shards = new LinkedHashMap<Shard, Node>();
        Map<String, Node> nodes = this.client.getHttpNodes(clientNodesOnly);
        block0: for (List<Map<String, Object>> shardGroup : info) {
            for (Map<String, Object> shardData : shardGroup) {
                Shard shard = new Shard(shardData);
                if (!shard.isPrimary()) continue;
                Node node = nodes.get(shard.getNode());
                if (node == null) {
                    log.warn((Object)String.format("Cannot find node with id [%s] (is HTTP enabled?) from shard [%s] in nodes [%s]; layout [%s]", shard.getNode(), shard, nodes, info));
                    return null;
                }
                shards.put(shard, node);
                continue block0;
            }
        }
        return shards;
    }

    public Field getMapping() {
        return Field.parseField(this.client.getMapping(this.resourceR.mapping()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> scroll(String scrollId, ScrollReader reader) throws IOException {
        InputStream scroll = this.client.scroll(scrollId);
        try {
            List<Object[]> list = reader.read(scroll);
            return list;
        }
        finally {
            if (scroll instanceof StatsAware) {
                this.stats.aggregate(((StatsAware)((Object)scroll)).stats());
            }
        }
    }

    public boolean indexExists(boolean read) {
        Resource res = read ? this.resourceR : this.resourceW;
        boolean exists = this.client.exists(res.indexAndType());
        if (!exists && read) {
            try {
                exists = !this.client.getMapping(res.mapping()).isEmpty();
            }
            catch (EsHadoopInvalidRequest ex) {
                exists = false;
            }
        }
        return exists;
    }

    private boolean isReadIndexConcrete() {
        String index = this.resourceR.index();
        return !index.contains(",") && !index.contains("*") && !this.client.isAlias(this.resourceR.aliases());
    }

    public void putMapping(BytesArray mapping) {
        this.client.putMapping(this.resourceW.index(), this.resourceW.mapping(), mapping.bytes());
    }

    public boolean touch() {
        return this.client.touch(this.resourceW.index());
    }

    public boolean waitForYellow() {
        return this.client.health(this.resourceW.index(), RestClient.HEALTH.YELLOW, TimeValue.timeValueSeconds(10L));
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.client != null) {
            copy.aggregate(this.client.stats());
        }
        return copy;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

