/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.util.List;
import java.util.Map;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.pig.PigTuple;
import org.elasticsearch.hadoop.pig.PigUtils;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.FilteringValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.util.FieldAlias;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.Booleans;

public class PigValueWriter
extends FilteringValueWriter<PigTuple> {
    private final boolean writeUnknownTypes;
    private boolean useTupleFieldNames;
    private FieldAlias alias;

    public PigValueWriter() {
        this(false);
    }

    public PigValueWriter(boolean useTupleFieldNames) {
        this.writeUnknownTypes = false;
        this.useTupleFieldNames = useTupleFieldNames;
        this.alias = new FieldAlias();
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        this.alias = PigUtils.alias(settings);
        this.useTupleFieldNames = Booleans.parseBoolean(settings.getProperty("es.mapping.pig.tuple.use.field.names"), false);
    }

    @Override
    public ValueWriter.Result write(PigTuple type, Generator generator) {
        return this.writeRootTuple(type.getTuple(), type.getSchema(), generator, true);
    }

    private ValueWriter.Result write(Object object, ResourceSchema.ResourceFieldSchema field, Generator generator) {
        byte type;
        byte by = type = field != null ? field.getType() : DataType.findType((Object)object);
        if (object == null) {
            generator.writeNull();
            return ValueWriter.Result.SUCCESFUL();
        }
        switch (type) {
            case -1: 
            case 0: {
                return this.handleUnknown(object, field, generator);
            }
            case 1: {
                generator.writeNull();
                break;
            }
            case 5: {
                generator.writeBoolean((Boolean)object);
                break;
            }
            case 10: {
                generator.writeNumber(((Number)object).intValue());
                break;
            }
            case 15: {
                generator.writeNumber(((Number)object).longValue());
                break;
            }
            case 20: {
                generator.writeNumber(((Number)object).floatValue());
                break;
            }
            case 25: {
                generator.writeNumber(((Number)object).doubleValue());
                break;
            }
            case 6: {
                generator.writeNumber((Byte)object);
                break;
            }
            case 55: {
                generator.writeString(object.toString());
                break;
            }
            case 50: {
                generator.writeBinary(((DataByteArray)object).get());
                break;
            }
            case 30: {
                generator.writeString(PigUtils.convertDateToES(object));
                break;
            }
            case 65: {
                throw new EsHadoopSerializationException("Big integers are not supported by Elasticsearch - consider using a different type (such as string)");
            }
            case 70: {
                throw new EsHadoopSerializationException("Big decimals are not supported by Elasticsearch - consider using a different type (such as string)");
            }
            case 100: {
                ResourceSchema nestedSchema = field.getSchema();
                if (nestedSchema == null) {
                    generator.writeBeginObject();
                    generator.writeEndObject();
                    break;
                }
                ResourceSchema.ResourceFieldSchema[] nestedFields = nestedSchema.getFields();
                generator.writeBeginObject();
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    String fieldName = entry.getKey().toString();
                    if (!this.shouldKeep(generator.getParentPath(), fieldName)) continue;
                    generator.writeFieldName(this.alias.toES(fieldName));
                    ValueWriter.Result result = this.write(entry.getValue(), nestedFields[0], generator);
                    if (result.isSuccesful()) continue;
                    return result;
                }
                generator.writeEndObject();
                break;
            }
            case 110: {
                return this.writeTuple(object, field, generator, this.useTupleFieldNames, false);
            }
            case 120: {
                ResourceSchema nestedSchema = field.getSchema();
                if (nestedSchema == null) {
                    generator.writeBeginArray();
                    generator.writeEndArray();
                    break;
                }
                ResourceSchema.ResourceFieldSchema bagType = nestedSchema.getFields()[0];
                generator.writeBeginArray();
                for (Tuple tuple : (DataBag)object) {
                    ValueWriter.Result result = this.write(tuple, bagType, generator);
                    if (result.isSuccesful()) continue;
                    return result;
                }
                generator.writeEndArray();
                break;
            }
            default: {
                if (this.writeUnknownTypes) {
                    return this.handleUnknown(object, field, generator);
                }
                return ValueWriter.Result.FAILED(object);
            }
        }
        return ValueWriter.Result.SUCCESFUL();
    }

    private ValueWriter.Result writeRootTuple(Tuple tuple, ResourceSchema.ResourceFieldSchema field, Generator generator, boolean writeTupleFieldNames) {
        return this.writeTuple(tuple, field, generator, writeTupleFieldNames, true);
    }

    private ValueWriter.Result writeTuple(Object object, ResourceSchema.ResourceFieldSchema field, Generator generator, boolean writeTupleFieldNames, boolean isRoot) {
        boolean isEmpty;
        ResourceSchema nestedSchema = field.getSchema();
        ValueWriter.Result result = ValueWriter.Result.SUCCESFUL();
        boolean writeAsObject = isRoot || writeTupleFieldNames;
        boolean bl = isEmpty = nestedSchema == null;
        if (!isEmpty) {
            boolean allEmpty = true;
            for (ResourceSchema.ResourceFieldSchema nestedField : nestedSchema.getFields()) {
                allEmpty &= nestedField.getSchema() == null && PigUtils.isComplexType(nestedField);
            }
            isEmpty = allEmpty;
        }
        if (isEmpty) {
            if (!isRoot) {
                generator.writeBeginArray();
            }
            if (writeAsObject) {
                generator.writeBeginObject();
                generator.writeEndObject();
            }
            if (!isRoot) {
                generator.writeEndArray();
            }
            return result;
        }
        ResourceSchema.ResourceFieldSchema[] nestedFields = nestedSchema.getFields();
        List tuples = ((Tuple)object).getAll();
        if (!isRoot) {
            generator.writeBeginArray();
        }
        if (writeAsObject) {
            generator.writeBeginObject();
        }
        for (int i = 0; i < nestedFields.length; ++i) {
            ValueWriter.Result res;
            if (writeAsObject) {
                String name = nestedFields[i].getName();
                name = StringUtils.hasText(name) ? this.alias.toES(name) : Integer.toString(i);
                generator.writeFieldName(name);
            }
            if ((res = this.write(tuples.get(i), nestedFields[i], generator)).isSuccesful()) continue;
            return res;
        }
        if (writeAsObject) {
            generator.writeEndObject();
        }
        if (!isRoot) {
            generator.writeEndArray();
        }
        return result;
    }

    protected ValueWriter.Result handleUnknown(Object value, ResourceSchema.ResourceFieldSchema field, Generator generator) {
        return ValueWriter.Result.FAILED(value);
    }
}

