/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.json;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;
import org.elasticsearch.hadoop.serialization.Parser;

public class JacksonJsonParser
implements Parser {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final JsonParser parser;

    public JacksonJsonParser(InputStream in) {
        try {
            this.parser = JSON_FACTORY.createJsonParser(in);
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    public JacksonJsonParser(byte[] content) {
        this(content, 0, content.length);
    }

    public JacksonJsonParser(byte[] content, int offset, int length) {
        try {
            this.parser = JSON_FACTORY.createJsonParser(content, offset, length);
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    public JacksonJsonParser(JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public Parser.Token currentToken() {
        return this.convertToken(this.parser.getCurrentToken());
    }

    @Override
    public Object currentValue() {
        try {
            return this.parser.getCurrentToken().isNumeric() ? this.parser.getNumberValue() : this.parser.getText();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Parser.Token nextToken() {
        try {
            return this.convertToken(this.parser.nextToken());
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    private Parser.Token convertToken(JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case FIELD_NAME: {
                return Parser.Token.FIELD_NAME;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return Parser.Token.VALUE_BOOLEAN;
            }
            case VALUE_STRING: {
                return Parser.Token.VALUE_STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return Parser.Token.VALUE_NUMBER;
            }
            case VALUE_NULL: {
                return Parser.Token.VALUE_NULL;
            }
            case START_OBJECT: {
                return Parser.Token.START_OBJECT;
            }
            case END_OBJECT: {
                return Parser.Token.END_OBJECT;
            }
            case START_ARRAY: {
                return Parser.Token.START_ARRAY;
            }
            case END_ARRAY: {
                return Parser.Token.END_ARRAY;
            }
            case VALUE_EMBEDDED_OBJECT: {
                return Parser.Token.VALUE_EMBEDDED_OBJECT;
            }
            case NOT_AVAILABLE: {
                throw new UnsupportedOperationException();
            }
        }
        throw new EsHadoopSerializationException("No matching token for json_token [" + token + "]");
    }

    @Override
    public void skipChildren() {
        try {
            this.parser.skipChildren();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public String currentName() {
        try {
            return this.parser.getCurrentName();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public String text() {
        try {
            return this.parser.getText();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public byte[] bytes() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public Number numberValue() {
        try {
            return this.parser.getNumberValue();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Parser.NumberType numberType() {
        try {
            return this.convertNumberType(this.parser.getNumberType());
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public short shortValue() {
        try {
            return this.parser.getShortValue();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public int intValue() {
        try {
            return this.parser.getIntValue();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public long longValue() {
        try {
            return this.parser.getLongValue();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public float floatValue() {
        try {
            return this.parser.getFloatValue();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public double doubleValue() {
        try {
            return this.parser.getDoubleValue();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public boolean booleanValue() {
        try {
            return this.parser.getBooleanValue();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public byte[] binaryValue() {
        try {
            return this.parser.getBinaryValue();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    private Parser.NumberType convertNumberType(JsonParser.NumberType numberType) {
        switch (numberType) {
            case INT: {
                return Parser.NumberType.INT;
            }
            case LONG: {
                return Parser.NumberType.LONG;
            }
            case FLOAT: {
                return Parser.NumberType.FLOAT;
            }
            case DOUBLE: {
                return Parser.NumberType.DOUBLE;
            }
            case BIG_INTEGER: {
                return Parser.NumberType.DOUBLE;
            }
            case BIG_DECIMAL: {
                return Parser.NumberType.DOUBLE;
            }
        }
        throw new EsHadoopSerializationException("No matching token for number_type [" + numberType + "]");
    }

    static {
        JSON_FACTORY.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        JSON_FACTORY.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        JSON_FACTORY.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

