/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.builder;

import java.io.OutputStream;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;

public class ContentBuilder {
    private final Generator generator;
    private final ValueWriter writer;

    private ContentBuilder(Generator generator, ValueWriter writer) {
        Assert.notNull(generator);
        this.generator = generator;
        this.writer = writer;
    }

    public static ContentBuilder generate(ValueWriter writer) {
        return new ContentBuilder(new JacksonJsonGenerator(new FastByteArrayOutputStream()), writer);
    }

    public static ContentBuilder generate(OutputStream bos, ValueWriter writer) {
        return new ContentBuilder(new JacksonJsonGenerator(bos), writer);
    }

    public ContentBuilder value(Object value) {
        if (!this.writer.write(value, this.generator)) {
            throw new EsHadoopSerializationException(String.format("Cannot handle type [%s], instance [%s] using writer [%s]", value.getClass(), value, this.writer));
        }
        return this;
    }

    public ContentBuilder flush() {
        this.generator.flush();
        return this;
    }

    public OutputStream content() {
        return (OutputStream)this.generator.getOutputTarget();
    }

    public void close() {
        this.generator.close();
    }
}

