/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class QueryBuilder {
    private final Resource resource;
    private static String MATCH_ALL = "{\"query\":{\"match_all\":{}}}";
    private Map<String, String> uriQuery = new LinkedHashMap<String, String>();
    private BytesArray bodyQuery;
    private TimeValue time = TimeValue.timeValueMinutes(10L);
    private long size = 50L;
    private String shard;
    private String node;
    private final boolean IS_ES_10;
    private final boolean INCLUDE_VERSION;
    private String fields;

    QueryBuilder(Settings settings) {
        this.resource = new Resource(settings, true);
        this.IS_ES_10 = SettingsUtils.isEs10(settings);
        this.INCLUDE_VERSION = settings.getReadMetadata() && settings.getReadMetadataVersion();
        String query = settings.getQuery();
        if (!StringUtils.hasText(query)) {
            query = MATCH_ALL;
        }
        this.parseQuery(query.trim(), settings);
    }

    public static QueryBuilder query(Settings settings) {
        return new QueryBuilder(settings).time(settings.getScrollKeepAlive()).size(settings.getScrollSize());
    }

    private void parseQuery(String query, Settings settings) {
        if (query.startsWith("?")) {
            this.uriQuery.putAll(this.initUriQuery(query));
        } else if (query.startsWith("{")) {
            this.bodyQuery = new BytesArray(query);
        } else {
            try {
                InputStream in = settings.loadResource(query);
                int first = in.read();
                if (Integer.valueOf(63).equals(first)) {
                    this.uriQuery.putAll(this.initUriQuery(IOUtils.asString(in)));
                } else {
                    this.bodyQuery = new BytesArray(1024);
                    this.bodyQuery.add(first);
                    IOUtils.asBytes(this.bodyQuery, in);
                }
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalArgumentException(String.format("Cannot determine specified query - doesn't appear to be URI or JSON based and location [%s] cannot be opened", query));
            }
        }
    }

    private Map<String, String> initUriQuery(String query) {
        if (query.startsWith("?")) {
            query = query.substring(1);
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (String token : query.split("&")) {
            int indexOf = token.indexOf("=");
            Assert.isTrue(indexOf > 0, String.format("Cannot token [%s] in uri query [%s]", token, query));
            params.put(token.substring(0, indexOf), token.substring(indexOf + 1));
        }
        return params;
    }

    public QueryBuilder size(long size) {
        this.size = size;
        return this;
    }

    public QueryBuilder time(long timeInMillis) {
        Assert.isTrue(timeInMillis > 0L, "Invalid time");
        this.time = TimeValue.timeValueMillis(timeInMillis);
        return this;
    }

    public QueryBuilder onlyNode(String node) {
        Assert.hasText(node, "Invalid node");
        this.node = node;
        return this;
    }

    public QueryBuilder shard(String shard) {
        Assert.hasText(shard, "Invalid shard");
        this.shard = shard;
        return this;
    }

    public QueryBuilder fields(String fieldsCSV) {
        this.fields = fieldsCSV;
        return this;
    }

    private String assemble() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.encodePath(this.resource.index()));
        sb.append("/");
        sb.append(StringUtils.encodePath(this.resource.type()));
        sb.append("/_search?");
        this.uriQuery.put("search_type", "scan");
        this.uriQuery.put("scroll", String.valueOf(this.time.minutes()));
        this.uriQuery.put("size", String.valueOf(this.size));
        if (this.INCLUDE_VERSION) {
            this.uriQuery.put("version", "");
        }
        if (StringUtils.hasText(this.fields)) {
            if (this.IS_ES_10) {
                this.uriQuery.put("_source", this.fields);
                this.uriQuery.remove("fields");
            } else {
                this.uriQuery.put("fields", this.fields);
            }
        } else {
            this.uriQuery.remove("fields");
        }
        StringBuilder pref = new StringBuilder();
        if (StringUtils.hasText(this.shard)) {
            pref.append("_shards:");
            pref.append(this.shard);
        }
        if (StringUtils.hasText(this.node)) {
            if (pref.length() > 0) {
                pref.append(";");
            }
            pref.append("_only_node:");
            pref.append(this.node);
        }
        if (pref.length() > 0) {
            this.uriQuery.put("preference", pref.toString());
        }
        Iterator<Map.Entry<String, String>> it = this.uriQuery.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sb.append(entry.getKey());
            if (StringUtils.hasText(entry.getValue())) {
                sb.append("=");
                sb.append(entry.getValue());
            }
            if (!it.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public ScrollQuery build(RestRepository client, ScrollReader reader) {
        String scrollUri = this.assemble();
        return client.scan(scrollUri, this.bodyQuery, reader);
    }

    public String toString() {
        return "QueryBuilder [" + this.assemble() + "]";
    }
}

