/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.rdd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.TaskContext;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestService;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.spark.serialization.ScalaMapFieldExtractor;
import org.elasticsearch.spark.serialization.ScalaValueWriter;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e4Q!\u0001\u0002\u0001\t)\u00111\"R:S\t\u0012;&/\u001b;fe*\u00111\u0001B\u0001\u0004e\u0012$'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"A\u0007fY\u0006\u001cH/[2tK\u0006\u00148\r\u001b\u0006\u0002\u0013\u0005\u0019qN]4\u0016\u0005-a3c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\f\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002%M,'/[1mSj,GmU3ui&twm]\u0002\u0001+\u0005I\u0002C\u0001\u000e\u001e\u001d\ti1$\u0003\u0002\u001d\u001d\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\tab\u0002\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001a\u0003M\u0019XM]5bY&TX\rZ*fiRLgnZ:!\u0011!\u0019\u0003AaA!\u0002\u0017!\u0013AC3wS\u0012,gnY3%cA\u0019Q\u0005\u000b\u0016\u000e\u0003\u0019R!a\n\b\u0002\u000fI,g\r\\3di&\u0011\u0011F\n\u0002\t\u00072\f7o\u001d+bOB\u00111\u0006\f\u0007\u0001\t\u0015i\u0003A1\u0001/\u0005\u0005!\u0016CA\u00183!\ti\u0001'\u0003\u00022\u001d\t9aj\u001c;iS:<\u0007CA\u00074\u0013\t!dBA\u0002B]fDQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtDC\u0001\u001d=)\tI4\bE\u0002;\u0001)j\u0011A\u0001\u0005\u0006GU\u0002\u001d\u0001\n\u0005\u0006-U\u0002\r!\u0007\u0005\b}\u0001\u0001\r\u0011\"\u0003@\u0003\rawnZ\u000b\u0002\u0001B\u0011\u0011\tS\u0007\u0002\u0005*\u00111\tR\u0001\bY><w-\u001b8h\u0015\t)e)A\u0004d_6lwN\\:\u000b\u0005\u001dC\u0011AB1qC\u000eDW-\u0003\u0002J\u0005\n\u0019Aj\\4\t\u000f-\u0003\u0001\u0019!C\u0005\u0019\u00069An\\4`I\u0015\fHCA'Q!\tia*\u0003\u0002P\u001d\t!QK\\5u\u0011\u001d\t&*!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u0011\u0019\u0019\u0006\u0001)Q\u0005\u0001\u0006!An\\4!\u0011!)\u0006\u0001#b\u0001\n\u00031\u0016\u0001C:fiRLgnZ:\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\u0007\r4wM\u0003\u0002]\r\u00051\u0001.\u00193p_BL!AX-\u0003\u0011M+G\u000f^5oOND\u0001\u0002\u0019\u0001\t\u0002\u0003\u0006KaV\u0001\ng\u0016$H/\u001b8hg\u0002BQA\u0019\u0001\u0005\u0002\r\fQa\u001e:ji\u0016$2!\u00143l\u0011\u0015)\u0017\r1\u0001g\u0003-!\u0018m]6D_:$X\r\u001f;\u0011\u0005\u001dLW\"\u00015\u000b\u0005\u00151\u0015B\u00016i\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000b1\f\u0007\u0019A7\u0002\t\u0011\fG/\u0019\t\u0004]ZTcBA8u\u001d\t\u00018/D\u0001r\u0015\t\u0011x#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QOD\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t)h\u0002")
public class EsRDDWriter<T>
implements Serializable {
    private final String serializedSettings;
    private Log log;
    private Settings settings;
    private volatile boolean bitmap$0;

    private Settings settings$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if (!this.bitmap$0) {
                this.settings = new PropertiesSettings().load(this.serializedSettings());
                this.bitmap$0 = true;
            }
            return this.settings;
        }
    }

    public String serializedSettings() {
        return this.serializedSettings;
    }

    private Log log() {
        return this.log;
    }

    private void log_$eq(Log x$1) {
        this.log = x$1;
    }

    public Settings settings() {
        return this.bitmap$0 ? this.settings : this.settings$lzycompute();
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        InitializationUtils.setValueWriterIfNotSet(this.settings(), ScalaValueWriter.class, this.log());
        InitializationUtils.setBytesConverterIfNeeded(this.settings(), JdkBytesConverter.class, this.log());
        InitializationUtils.setFieldExtractorIfNotSet(this.settings(), ScalaMapFieldExtractor.class, this.log());
        RestService.PartitionWriter writer = RestService.createWriter(this.settings(), taskContext.partitionId(), -1, this.log());
        taskContext.addOnCompleteCallback((Function0)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final RestService.PartitionWriter writer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.writer$1.close();
            }
            {
                this.writer$1 = writer$1;
            }
        });
        while (data.hasNext()) {
            writer.repository.writeToIndex(data.next());
        }
    }

    public EsRDDWriter(String serializedSettings, ClassTag<T> evidence$1) {
        this.serializedSettings = serializedSettings;
        this.log = LogFactory.getLog(EsRDDWriter.class);
    }
}

