/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;

public class ConstantFieldExtractor
implements FieldExtractor,
SettingsAware {
    public static final String PROPERTY = "org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property";
    private String fieldName;
    private Object value;

    @Override
    public final Object field(Object target) {
        return this.value != null ? this.value : this.extractField(target);
    }

    protected Object extractField(Object target) {
        return NOT_FOUND;
    }

    @Override
    public void setSettings(Settings settings) {
        this.fieldName = this.property(settings);
        if (this.fieldName.startsWith("<") && this.fieldName.endsWith(">")) {
            this.value = this.initValue(this.fieldName.substring(1, this.fieldName.length() - 1));
        }
    }

    protected Object initValue(String value) {
        return value;
    }

    protected String property(Settings settings) {
        String value = settings.getProperty(PROPERTY);
        return value == null ? "" : value.trim();
    }

    protected String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return String.format("%s for field [%s]", this.getClass().getSimpleName(), this.fieldName);
    }
}

