/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.util.Progressable;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.HadoopCfgUtils;
import org.elasticsearch.hadoop.mr.HeartBeat;
import org.elasticsearch.hadoop.mr.LinkedMapWritable;
import org.elasticsearch.hadoop.mr.ReportingUtils;
import org.elasticsearch.hadoop.mr.WritableValueReader;
import org.elasticsearch.hadoop.mr.compat.CompatHandler;
import org.elasticsearch.hadoop.mr.compat.JobContext;
import org.elasticsearch.hadoop.mr.compat.TaskAttemptContext;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.QueryBuilder;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.RestService;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.util.StringUtils;

public class EsInputFormat<K, V>
extends InputFormat<K, V>
implements org.apache.hadoop.mapred.InputFormat<K, V> {
    private static Log log = LogFactory.getLog(EsInputFormat.class);

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        JobContext compatJobContext = CompatHandler.jobContext(context);
        JobConf conf = HadoopCfgUtils.asJobConf(compatJobContext.getConfiguration());
        return Arrays.asList((org.apache.hadoop.mapreduce.InputSplit[])this.getSplits(conf, conf.getNumMapTasks()));
    }

    public ShardRecordReader<K, V> createRecordReader(org.apache.hadoop.mapreduce.InputSplit split, org.apache.hadoop.mapreduce.TaskAttemptContext context) {
        return new WritableShardRecordReader();
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Settings settings = HadoopSettingsManager.loadFrom(job);
        Collection<RestService.PartitionDefinition> partitions = RestService.findPartitions(settings, log);
        InputSplit[] splits = new ShardInputSplit[partitions.size()];
        int index = 0;
        for (RestService.PartitionDefinition part : partitions) {
            splits[index++] = new ShardInputSplit(part.nodeIp, part.nodePort, part.nodeId, part.nodeName, part.shardId, part.serializedMapping, part.serializedSettings);
        }
        log.info((Object)String.format("Created [%d] shard-splits", splits.length));
        return splits;
    }

    public ShardRecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) {
        return new WritableShardRecordReader(split, (Configuration)job, reporter);
    }

    protected static class WritableShardRecordReader
    extends ShardRecordReader<Text, Map<Writable, Writable>> {
        private boolean useLinkedMapWritable = true;

        public WritableShardRecordReader() {
        }

        public WritableShardRecordReader(InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        void init(ShardInputSplit esSplit, Configuration cfg, Progressable progressable) {
            this.useLinkedMapWritable = !MapWritable.class.getName().equals(HadoopCfgUtils.getMapValueClass(cfg));
            super.init(esSplit, cfg, progressable);
        }

        @Override
        public Text createKey() {
            return new Text();
        }

        @Override
        public Map<Writable, Writable> createValue() {
            return this.useLinkedMapWritable ? new LinkedMapWritable() : new MapWritable();
        }

        @Override
        protected Text setCurrentKey(Text oldApiKey, Text newApiKey, Object object) {
            String val = object.toString();
            if (oldApiKey == null) {
                oldApiKey = new Text();
                oldApiKey.set(val);
            }
            if (newApiKey != null) {
                newApiKey.set(val);
            }
            return oldApiKey;
        }

        @Override
        protected Map<Writable, Writable> setCurrentValue(Map<Writable, Writable> oldApiValue, Map<Writable, Writable> newApiKey, Object object) {
            Map val = (Map)object;
            if (newApiKey != null) {
                newApiKey.clear();
                newApiKey.putAll(val);
            }
            return val;
        }
    }

    protected static abstract class ShardRecordReader<K, V>
    extends RecordReader<K, V>
    implements org.apache.hadoop.mapred.RecordReader<K, V> {
        private int read = 0;
        private ShardInputSplit esSplit;
        private ScrollReader scrollReader;
        private RestRepository client;
        private QueryBuilder queryBuilder;
        private ScrollQuery scrollQuery;
        private K currentKey;
        private V currentValue;
        private long size = 0L;
        private HeartBeat beat;
        private Progressable progressable;

        public ShardRecordReader() {
        }

        public ShardRecordReader(InputSplit split, Configuration job, Reporter reporter) {
            reporter.setStatus(split.toString());
            this.init((ShardInputSplit)split, job, (Progressable)reporter);
        }

        public void initialize(org.apache.hadoop.mapreduce.InputSplit split, org.apache.hadoop.mapreduce.TaskAttemptContext context) throws IOException {
            TaskAttemptContext compatContext = CompatHandler.taskAttemptContext(context);
            compatContext.setStatus(split.toString());
            this.init((ShardInputSplit)split, compatContext.getConfiguration(), compatContext);
        }

        void init(ShardInputSplit esSplit, Configuration cfg, Progressable progressable) {
            Settings settings = HadoopSettingsManager.loadFrom(cfg).copy().load(esSplit.settings);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Init shard reader from cfg %s", HadoopCfgUtils.asProperties(cfg)));
                log.trace((Object)String.format("Init shard reader w/ settings %s", esSplit.settings));
            }
            settings.setHosts(esSplit.nodeIp).setPort(esSplit.httpPort);
            this.esSplit = esSplit;
            InitializationUtils.setValueReaderIfNotSet(settings, WritableValueReader.class, log);
            RestService.PartitionDefinition part = new RestService.PartitionDefinition(esSplit.nodeIp, esSplit.httpPort, esSplit.nodeName, esSplit.nodeId, esSplit.shardId, settings.save(), esSplit.mapping);
            RestService.PartitionReader partitionReader = RestService.createReader(settings, part, log);
            this.scrollReader = partitionReader.scrollReader;
            this.client = partitionReader.client;
            this.queryBuilder = partitionReader.queryBuilder;
            this.beat = new HeartBeat(progressable, cfg, settings.getHeartBeatLead(), log);
            this.progressable = progressable;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Initializing RecordReader for [%s]", new Object[]{esSplit}));
            }
        }

        public boolean nextKeyValue() throws IOException {
            if (this.currentKey == null) {
                this.currentKey = this.createKey();
            }
            if (this.currentValue == null) {
                this.currentValue = this.createValue();
            }
            return this.next(this.currentKey, this.currentValue);
        }

        public K getCurrentKey() throws IOException {
            return this.currentKey;
        }

        public V getCurrentValue() {
            return this.currentValue;
        }

        public float getProgress() {
            return this.size == 0L ? 0.0f : (float)this.getPos() / (float)this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Closing RecordReader for [%s]", new Object[]{this.esSplit}));
                }
                if (this.beat != null) {
                    this.beat.stop();
                }
                if (this.scrollQuery != null) {
                    this.scrollQuery.close();
                }
                if (this.client != null) {
                    this.client.close();
                }
            }
            finally {
                Stats stats = new Stats();
                if (this.client != null) {
                    stats.aggregate(this.client.stats());
                    this.client = null;
                }
                if (this.scrollQuery != null) {
                    stats.aggregate(this.scrollQuery.stats());
                    this.scrollQuery = null;
                }
                ReportingUtils.report(this.progressable, stats);
            }
        }

        public boolean next(K key, V value) throws IOException {
            boolean hasNext;
            if (this.scrollQuery == null) {
                this.beat.start();
                this.scrollQuery = this.queryBuilder.build(this.client, this.scrollReader);
                this.size = this.scrollQuery.getSize();
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Received scroll [%s],  size [%d] for query [%s]", this.scrollQuery, this.size, this.queryBuilder));
                }
            }
            if (!(hasNext = this.scrollQuery.hasNext())) {
                return false;
            }
            Object[] next = this.scrollQuery.next();
            this.currentKey = this.setCurrentKey(this.currentKey, key, next[0]);
            this.currentValue = this.setCurrentValue(this.currentValue, value, next[1]);
            ++this.read;
            return true;
        }

        public abstract K createKey();

        public abstract V createValue();

        protected abstract K setCurrentKey(K var1, K var2, Object var3);

        protected abstract V setCurrentValue(V var1, V var2, Object var3);

        public long getPos() {
            return this.read;
        }
    }

    protected static class ShardInputSplit
    extends org.apache.hadoop.mapreduce.InputSplit
    implements InputSplit {
        private String nodeIp;
        private int httpPort;
        private String nodeId;
        private String nodeName;
        private String shardId;
        private String mapping;
        private String settings;

        public ShardInputSplit() {
        }

        public ShardInputSplit(String nodeIp, int httpPort, String nodeId, String nodeName, String shard, String mapping, String settings) {
            this.nodeIp = nodeIp;
            this.httpPort = httpPort;
            this.nodeId = nodeId;
            this.nodeName = nodeName;
            this.shardId = shard;
            this.mapping = mapping;
            this.settings = settings;
        }

        public long getLength() {
            return 1L;
        }

        public String[] getLocations() {
            return new String[]{this.nodeIp};
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.nodeIp);
            out.writeInt(this.httpPort);
            out.writeUTF(this.nodeId);
            out.writeUTF(this.nodeName);
            out.writeUTF(this.shardId);
            byte[] utf = StringUtils.toUTF(this.mapping);
            out.writeInt(utf.length);
            out.write(utf);
            utf = StringUtils.toUTF(this.settings);
            out.writeInt(utf.length);
            out.write(utf);
        }

        public void readFields(DataInput in) throws IOException {
            this.nodeIp = in.readUTF();
            this.httpPort = in.readInt();
            this.nodeId = in.readUTF();
            this.nodeName = in.readUTF();
            this.shardId = in.readUTF();
            int length = in.readInt();
            byte[] utf = new byte[length];
            in.readFully(utf);
            this.mapping = StringUtils.asUTFString(utf);
            length = in.readInt();
            utf = new byte[length];
            in.readFully(utf);
            this.settings = StringUtils.asUTFString(utf);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ShardInputSplit [node=[").append(this.nodeId).append("/").append(this.nodeName).append("|").append(this.nodeIp).append(":").append(this.httpPort).append("],shard=").append(this.shardId).append("]");
            return builder.toString();
        }
    }
}

