/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.hive.HiveType;
import org.elasticsearch.hadoop.hive.HiveUtils;
import org.elasticsearch.hadoop.serialization.field.ConstantFieldExtractor;
import org.elasticsearch.hadoop.util.Assert;

public class HiveFieldExtractor
extends ConstantFieldExtractor {
    private String fieldName;

    @Override
    protected Object extractField(Object target) {
        HiveType type;
        ObjectInspector inspector;
        if (target instanceof HiveType && (inspector = (type = (HiveType)target).getObjectInspector()) instanceof StructObjectInspector) {
            StructObjectInspector soi = (StructObjectInspector)inspector;
            StructField field = soi.getStructFieldRef(this.fieldName);
            ObjectInspector foi = field.getFieldObjectInspector();
            Assert.isTrue(foi.getCategory() == ObjectInspector.Category.PRIMITIVE, String.format("Field [%s] needs to be a primitive; found [%s]", this.fieldName, foi.getTypeName()));
            Object data = soi.getStructFieldData(type.getObject(), field);
            if (data == null || data instanceof NullWritable) {
                return "";
            }
            return data.toString();
        }
        return null;
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        Map<String, String> columnNames = HiveUtils.columnMap(settings);
        this.fieldName = columnNames.get(this.getFieldName().toLowerCase(Locale.ENGLISH));
    }
}

