/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.Collection;
import org.elasticsearch.hadoop.serialization.builder.ContentBuilder;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.bulk.AbstractBulkFactory;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.BytesRef;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;

class TemplatedBulk
implements BulkCommand {
    private final Collection<Object> beforeObject;
    private final Collection<Object> afterObject;
    private BytesArray scratchPad = new BytesArray(1024);
    private BytesRef ref = new BytesRef();
    private final ValueWriter valueWriter;

    TemplatedBulk(Collection<Object> beforeObject, Collection<Object> afterObject, ValueWriter<?> valueWriter) {
        this.beforeObject = beforeObject;
        this.afterObject = afterObject;
        this.valueWriter = valueWriter;
    }

    @Override
    public BytesRef write(Object object) {
        this.ref.reset();
        this.scratchPad.reset();
        Object processed = this.preProcess(object, this.scratchPad);
        this.writeTemplate(this.beforeObject, processed);
        this.doWriteObject(processed, this.scratchPad, this.valueWriter);
        this.ref.add(this.scratchPad);
        this.writeTemplate(this.afterObject, processed);
        return this.ref;
    }

    protected Object preProcess(Object object, BytesArray storage) {
        return object;
    }

    protected void doWriteObject(Object object, BytesArray storage, ValueWriter<?> writer) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(storage);
        ContentBuilder.generate(bos, writer).value(object).flush().close();
    }

    private void writeTemplate(Collection<Object> template, Object object) {
        for (Object item : template) {
            if (item instanceof byte[]) {
                this.ref.add((byte[])item);
                continue;
            }
            this.ref.add(((AbstractBulkFactory.FieldWriter)item).write(object));
        }
    }
}

