/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.hive.HiveConstants;
import org.elasticsearch.hadoop.hive.HiveFieldExtractor;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.util.FieldAlias;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.Booleans;

abstract class HiveUtils {
    static final boolean DATE_WRITABLE_AVAILABLE = ObjectUtils.isClassPresent("org.apache.hadoop.hive.serde2.io.DateWritable", TimestampWritable.class.getClassLoader());

    HiveUtils() {
    }

    static StandardStructObjectInspector structObjectInspector(Properties tableProperties) {
        List<String> columnNames = StringUtils.tokenize(tableProperties.getProperty("columns"), ",");
        ArrayList colTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)tableProperties.getProperty("columns.types"));
        ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>();
        for (TypeInfo typeInfo : colTypes) {
            inspectors.add(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
    }

    static StructTypeInfo typeInfo(StructObjectInspector inspector) {
        return (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)inspector);
    }

    static Collection<String> columnToAlias(Settings settings) {
        FieldAlias fa = HiveUtils.alias(settings);
        List<String> columnNames = StringUtils.tokenize(settings.getProperty("columns"), ",");
        for (String vc : HiveConstants.VIRTUAL_COLUMNS) {
            columnNames.remove(vc);
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            String original = columnNames.get(i);
            String alias = fa.toES(original);
            if (alias == null) continue;
            columnNames.set(i, alias);
        }
        return columnNames;
    }

    static FieldAlias alias(Settings settings) {
        Map<String, String> aliasMap = SettingsUtils.aliases(settings.getProperty("es.mapping.names"));
        Map<String, String> columnMap = HiveUtils.columnMap(settings);
        for (Map.Entry<String, String> entry : columnMap.entrySet()) {
            String alias;
            String columnName = entry.getKey();
            String columnIndex = entry.getValue();
            if (!aliasMap.isEmpty() && (alias = aliasMap.get(columnName)) != null) {
                columnName = alias;
            }
            aliasMap.put(columnIndex, columnName);
        }
        return new FieldAlias(aliasMap);
    }

    static Map<String, String> columnMap(Settings settings) {
        return HiveUtils.columnMap(settings.getProperty("columns"));
    }

    private static Map<String, String> columnMap(String columnString) {
        List<String> columnNames = StringUtils.tokenize(columnString, ",");
        if (columnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        for (int i = 0; i < columnNames.size(); ++i) {
            columns.put(columnNames.get(i), "_col" + i);
        }
        return columns;
    }

    static void init(Settings settings, Log log) {
        InitializationUtils.checkIdForOperation(settings);
        InitializationUtils.setFieldExtractorIfNotSet(settings, HiveFieldExtractor.class, log);
        try {
            InitializationUtils.discoverEsVersion(settings, log);
        }
        catch (IOException ex) {
            throw new EsHadoopIllegalStateException("Cannot discover Elasticsearch version", ex);
        }
    }

    static void fixHive13InvalidComments(Settings settings, Properties tbl) {
        if (Booleans.parseBoolean(settings.getProperty("es.hive.disable.columns.comments.fix"))) {
            return;
        }
        settings.setProperty("columns.comments", "");
        tbl.remove("columns.comments");
    }
}

