/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.HttpRetryPolicy;
import org.elasticsearch.hadoop.rest.HttpStatus;
import org.elasticsearch.hadoop.rest.Retry;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class SimpleHttpRetryPolicy
implements HttpRetryPolicy,
SettingsAware {
    private static Log log = LogFactory.getLog(SimpleHttpRetryPolicy.class);
    private int retryLimit;
    private long retryTime;

    @Override
    public Retry init() {
        return new SimpleRetry();
    }

    @Override
    public void setSettings(Settings settings) {
        this.retryLimit = settings.getBatchWriteRetryCount();
        this.retryTime = settings.getBatchWriteRetryWait();
    }

    private class SimpleRetry
    implements Retry {
        private int retryCount = 0;

        private SimpleRetry() {
        }

        @Override
        public boolean retry(int httpStatus) {
            if (HttpStatus.isSuccess(httpStatus)) {
                return false;
            }
            switch (httpStatus) {
                case 503: {
                    if (++this.retryCount < SimpleHttpRetryPolicy.this.retryLimit) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Elasticsearch service unavailable - retrying in %s", TimeValue.timeValueMillis(SimpleHttpRetryPolicy.this.retryTime)));
                            }
                            Thread.sleep(SimpleHttpRetryPolicy.this.retryTime);
                            return true;
                        }
                        catch (InterruptedException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Thread interrupted - giving up on retrying...", new Object[0]));
                            }
                            return false;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
    }
}

