/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;

public abstract class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeToBase64(Serializable object) throws IOException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(object);
        }
        finally {
            IOUtils.close(oos);
        }
        return DatatypeConverter.printBase64Binary((byte[])baos.bytes().bytes());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T deserializeFromBase64(String data) {
        Serializable serializable;
        byte[] rawData = DatatypeConverter.parseBase64Binary((String)data);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FastByteArrayInputStream(rawData));
            Object o = ois.readObject();
            serializable = (Serializable)o;
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new EsHadoopIllegalStateException("cannot deserialize object", ex);
                catch (IOException ex2) {
                    throw new EsHadoopSerializationException("cannot deserialize object", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(ois);
                throw throwable;
            }
        }
        IOUtils.close(ois);
        return (T)serializable;
    }

    public static String propsToString(Properties props) {
        StringWriter sw = new StringWriter();
        if (props != null) {
            try {
                props.store(sw, "");
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalArgumentException(ex);
            }
        }
        return sw.toString();
    }

    public static Properties propsFromString(String source) {
        Properties copy = new Properties();
        if (source != null) {
            try {
                copy.load(new StringReader(source));
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalArgumentException(ex);
            }
        }
        return copy;
    }

    public static BytesArray asBytes(InputStream in) throws IOException {
        return IOUtils.asBytes(new BytesArray(in.available()), in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytesArray asBytes(BytesArray ba, InputStream in) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(ba);
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = in.read(buffer)) != -1) {
                bos.write(buffer, 0, read);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
        return bos.bytes();
    }

    public static String asString(InputStream in) throws IOException {
        return IOUtils.asBytes(in).toString();
    }

    public static InputStream open(String resource, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = IOUtils.class.getClassLoader();
        }
        try {
            if (!resource.contains(":")) {
                return loader.getResourceAsStream(resource);
            }
            return new URL(resource).openStream();
        }
        catch (IOException ex) {
            throw new EsHadoopIllegalArgumentException(String.format("Cannot open stream for resource %s", resource));
        }
    }

    public static InputStream open(String location) {
        return IOUtils.open(location, null);
    }

    public static void close(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

