/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.command;

import java.util.List;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.command.AbstractCommandFactory;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.Assert;

class UpdateCommandFactory
extends AbstractCommandFactory {
    private final boolean UPSERT_DOC;

    public UpdateCommandFactory(Settings settings) {
        super(settings);
        this.UPSERT_DOC = settings.getUpsertDoc();
    }

    @Override
    protected String getOperation() {
        return "update";
    }

    @Override
    protected void writeBeforeObject(List<Object> pieces) {
        super.writeBeforeObject(pieces);
        pieces.add("{");
        if (this.UPSERT_DOC) {
            pieces.add("\"doc_as_upsert\":true,");
        }
        pieces.add("\"doc\":");
    }

    @Override
    protected void writeAfterObject(List<Object> after) {
        after.add("}");
        super.writeAfterObject(after);
    }

    @Override
    protected FieldExtractor id() {
        FieldExtractor id = super.id();
        Assert.notNull(id, String.format("Operation [%s] requires an id but none was given/found", this.getOperation()));
        return id;
    }
}

