/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.command;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.builder.NoOpValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.command.TemplatedCommand;
import org.elasticsearch.hadoop.serialization.field.JsonFieldExtractors;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.ObjectUtils;

class JsonTemplatedCommand
extends TemplatedCommand {
    private static Log log = LogFactory.getLog(JsonTemplatedCommand.class);
    private final JsonFieldExtractors jsonExtractors;
    private final BytesConverter jsonWriter;

    public JsonTemplatedCommand(Collection<Object> beforeObject, Collection<Object> afterObject, JsonFieldExtractors jsonExtractors, Settings settings) {
        super(beforeObject, afterObject, new NoOpValueWriter());
        this.jsonExtractors = jsonExtractors;
        this.jsonWriter = (BytesConverter)ObjectUtils.instantiate(settings.getSerializerBytesConverterClassName(), settings);
    }

    @Override
    protected Object preProcess(Object object, BytesArray storage) {
        Assert.notNull(object, "Empty/null JSON document given...");
        this.jsonWriter.convert(object, storage);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("About to extract information from [%s]", storage));
        }
        this.jsonExtractors.process(storage);
        return storage;
    }

    @Override
    protected void doWriteObject(Object object, BytesArray storage, ValueWriter<?> writer) {
    }
}

