/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.command;

import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.command.AbstractCommandFactory;
import org.elasticsearch.hadoop.serialization.command.Command;
import org.elasticsearch.hadoop.serialization.command.CreateCommandFactory;
import org.elasticsearch.hadoop.serialization.command.IndexCommandFactory;
import org.elasticsearch.hadoop.serialization.command.UpdateCommandFactory;

public abstract class BulkCommands {
    public static Command create(Settings settings) {
        String operation = settings.getOperation();
        AbstractCommandFactory factory = null;
        if ("create".equals(operation)) {
            factory = new CreateCommandFactory(settings);
        } else if ("index".equals(operation)) {
            factory = new IndexCommandFactory(settings);
        } else if ("update".equals(operation)) {
            factory = new UpdateCommandFactory(settings);
        } else {
            throw new EsHadoopIllegalArgumentException("Unknown operation " + operation);
        }
        return factory.createCommand();
    }
}

