/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public enum FieldType {
    NULL,
    BOOLEAN,
    BYTE,
    SHORT,
    INTEGER,
    LONG,
    FLOAT,
    DOUBLE,
    STRING,
    DATE,
    BINARY,
    TOKEN_COUNT,
    OBJECT,
    MULTI_FIELD,
    NESTED,
    IP,
    GEO_POINT,
    GEO_SHAPE,
    POINT,
    LINESTRING,
    POLYGON,
    MULTIPOINT,
    MULTIPOLYGON,
    ENVELOPE,
    COMPLETION;

    private static final Set<String> KNOWN_TYPES;

    public static FieldType parse(String name) {
        String n = name != null ? name.toUpperCase(Locale.ENGLISH) : name;
        return KNOWN_TYPES.contains(n) ? FieldType.valueOf(n) : null;
    }

    public static boolean isRelevant(FieldType fieldType) {
        if (fieldType == null || COMPLETION == fieldType) {
            return false;
        }
        if (IP == fieldType || GEO_POINT == fieldType || GEO_SHAPE == fieldType || POINT == fieldType || LINESTRING == fieldType || POLYGON == fieldType || MULTIPOINT == fieldType || MULTIPOLYGON == fieldType || ENVELOPE == fieldType) {
            return true;
        }
        return true;
    }

    static {
        KNOWN_TYPES = new LinkedHashSet<String>();
        for (FieldType fieldType : EnumSet.allOf(FieldType.class)) {
            KNOWN_TYPES.add(fieldType.name());
        }
    }
}

