/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.dto.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.FieldPresenceValidation;
import org.elasticsearch.hadoop.rest.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.util.StringUtils;

public class MappingUtils {
    private static final Set<String> BUILT_IN_FIELDS = new HashSet<String>();

    public static void validateMapping(String fields, Field mapping, FieldPresenceValidation validation, Log log) {
        if (StringUtils.hasText(fields)) {
            MappingUtils.validateMapping(StringUtils.tokenize(fields), mapping, validation, log);
        }
    }

    public static void validateMapping(Collection<String> fields, Field mapping, FieldPresenceValidation validation, Log log) {
        if (mapping == null || fields == null || fields.isEmpty() || validation == null || FieldPresenceValidation.IGNORE == validation) {
            return;
        }
        List[] results = MappingUtils.findTypos(fields, mapping);
        if (results == null) {
            return;
        }
        String message = String.format("Field(s) [%s]  not found in the Elasticsearch mapping specified; did you mean [%s]?", MappingUtils.removeDoubleBrackets(results[0]), MappingUtils.removeDoubleBrackets(results[1]));
        if (validation != FieldPresenceValidation.WARN) {
            throw new EsHadoopIllegalArgumentException(message);
        }
        log.warn((Object)message);
    }

    static List[] findTypos(Collection<String> fields, Field mapping) {
        Map<String, FieldType> map = Field.toLookupMap(mapping);
        ArrayList<String> missing = new ArrayList<String>(fields.size());
        for (String field : fields) {
            if (map.containsKey(field) || MappingUtils.isBuiltIn(field)) continue;
            missing.add(field);
        }
        if (missing.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> unwrapped = new LinkedHashMap<String, String>();
        for (Map.Entry<String, FieldType> entry : map.entrySet()) {
            String leafField;
            String key = entry.getKey();
            int match = key.lastIndexOf(".");
            if (match > 0 && !unwrapped.containsKey(leafField = key.substring(match + 1))) {
                unwrapped.put(leafField, key);
            }
            unwrapped.put(key, key);
        }
        ArrayList typos = new ArrayList();
        Set<String> similar = unwrapped.keySet();
        for (String string : missing) {
            List<String> matches = StringUtils.findSimiliar(string, similar);
            for (String match : matches) {
                typos.add(unwrapped.get(match));
            }
        }
        return new List[]{missing, typos};
    }

    private static boolean isBuiltIn(String field) {
        return BUILT_IN_FIELDS.contains(field);
    }

    private static String removeDoubleBrackets(List col) {
        if (col.isEmpty()) {
            return "<no-similar-match-found>";
        }
        if (col.size() == 1) {
            return col.get(0).toString();
        }
        return col.toString();
    }

    static {
        BUILT_IN_FIELDS.addAll(Arrays.asList("_uid", "_id", "_type", "_source", "_all", "_analyzer", "_boost", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl"));
    }
}

