/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.InputStream;
import org.elasticsearch.hadoop.rest.HttpStatus;
import org.elasticsearch.hadoop.rest.Response;

public class SimpleResponse
implements Response {
    private final int status;
    private final InputStream body;
    private final CharSequence uri;

    public SimpleResponse(int status, InputStream body, CharSequence uri) {
        this.status = status;
        this.body = body;
        this.uri = uri;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public String statusDescription() {
        return HttpStatus.getText(this.status);
    }

    @Override
    public InputStream body() {
        return this.body;
    }

    @Override
    public CharSequence uri() {
        return this.uri;
    }

    @Override
    public boolean isInformal() {
        return HttpStatus.isInformal(this.status);
    }

    @Override
    public boolean isSuccess() {
        return HttpStatus.isSuccess(this.status);
    }

    @Override
    public boolean isRedirection() {
        return HttpStatus.isRedirection(this.status);
    }

    @Override
    public boolean isClientError() {
        return HttpStatus.isClientError(this.status);
    }

    @Override
    public boolean isServerError() {
        return HttpStatus.isServerError(this.status);
    }

    @Override
    public boolean hasSucceeded() {
        return this.isSuccess();
    }

    @Override
    public boolean hasFailed() {
        return !this.hasSucceeded();
    }
}

