/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;

public class Resource {
    private final String indexAndType;
    private final String type;
    private final String index;
    private final String bulk;
    private final String refresh;

    public Resource(Settings settings, boolean read) {
        String res;
        int slash;
        String resource = read ? settings.getResourceRead() : settings.getResourceWrite();
        String errorMessage = "invalid resource given; expecting [index]/[type]";
        Assert.hasText(resource, errorMessage);
        if (resource.contains("?") || resource.contains("&")) {
            if (StringUtils.hasText(settings.getQuery())) {
                throw new EsHadoopIllegalArgumentException(String.format("Cannot specify a query in the target index and through %s", "es.query"));
            }
            LogFactory.getLog(Resource.class).warn((Object)String.format("queries should be specified through '%s' option and not the target index; this option will be _removed_ in the next release", "es.query"));
            int index = resource.indexOf("?");
            if (index > 0) {
                String query = resource.substring(index);
                Assert.isTrue((index = (resource = resource.substring(0, index)).lastIndexOf("/")) >= 0 && index < resource.length() - 1, errorMessage);
                resource = resource.substring(0, index);
                settings.setProperty("es.resource", resource);
                settings.setQuery(query);
            }
        }
        Assert.isTrue((slash = (res = StringUtils.sanitizeResource(resource)).indexOf("/")) >= 0 && slash < res.length() - 1, errorMessage);
        this.index = res.substring(0, slash);
        this.type = res.substring(slash + 1);
        Assert.hasText(this.index, "No index found; expecting [index]/[type]");
        Assert.hasText(this.type, "No type found; expecting [index]/[type]");
        this.indexAndType = this.index + "/" + this.type;
        this.bulk = this.indexAndType.contains("{") ? "/_bulk" : this.indexAndType + "/_bulk";
        this.refresh = this.index.contains("{") ? "/_refresh" : this.index + "/_refresh";
    }

    String bulk() {
        return this.bulk;
    }

    String targetShards() {
        return this.indexAndType + "/_search_shards";
    }

    String mapping() {
        return this.indexAndType + "/_mapping";
    }

    String indexAndType() {
        return this.indexAndType;
    }

    String type() {
        return this.type;
    }

    String index() {
        return this.index;
    }

    public String toString() {
        return this.indexAndType;
    }

    public String refresh() {
        return this.refresh;
    }
}

