/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.EsHadoopProtocolException;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.SimpleRequest;
import org.elasticsearch.hadoop.rest.Transport;
import org.elasticsearch.hadoop.rest.commonshttp.CommonsHttpTransport;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.ByteSequence;

public class NetworkClient
implements StatsAware,
Closeable {
    private static Log log = LogFactory.getLog(NetworkClient.class);
    private final Settings settings;
    private final List<String> nodes;
    private Transport currentTransport;
    private String currentUri;
    private int nextClient = 0;
    private final Stats stats = new Stats();

    public NetworkClient(Settings settings, List<String> hostURIs) {
        this.settings = settings.copy();
        this.nodes = hostURIs;
        this.selectNextNode();
        Assert.notNull(this.currentTransport, "no node information provided");
    }

    private boolean selectNextNode() {
        if (this.nextClient >= this.nodes.size()) {
            return false;
        }
        if (this.currentTransport != null) {
            ++this.stats.nodeRetries;
        }
        this.closeTransport();
        this.currentUri = this.nodes.get(this.nextClient++);
        this.settings.setHosts(this.currentUri);
        this.currentTransport = new CommonsHttpTransport(this.settings, this.currentUri);
        return true;
    }

    public Response execute(Request request) throws EsHadoopProtocolException {
        boolean newNode;
        Response response = null;
        SimpleRequest routedRequest = new SimpleRequest(request.method(), this.currentUri, request.path(), request.params(), request.body());
        do {
            newNode = false;
            try {
                response = this.currentTransport.execute(routedRequest);
                ByteSequence body = routedRequest.body();
                if (body == null) continue;
                this.stats.bytesWritten += (long)body.length();
            }
            catch (Exception ex) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Caught exception while performing request [%s][%s] - falling back to the next node in line...", this.currentUri, request.path()), (Throwable)ex);
                }
                String failed = this.currentUri;
                newNode = this.selectNextNode();
                log.error((Object)String.format("Node [%s] failed; " + (newNode ? "selected next node [" + this.currentUri + "]" : "no other nodes left - aborting..."), failed));
                if (newNode) continue;
                throw new EsHadoopProtocolException("Connection error (check network and/or proxy settings) - out of nodes and retries", ex);
            }
        } while (newNode);
        return response;
    }

    @Override
    public void close() {
        this.closeTransport();
    }

    private void closeTransport() {
        if (this.currentTransport != null) {
            this.currentTransport.close();
            this.stats.aggregate(this.currentTransport.stats());
            this.currentTransport = null;
        }
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.currentTransport != null) {
            copy.aggregate(this.currentTransport.stats());
        }
        return copy;
    }

    Stats transportStats() {
        return this.currentTransport.stats();
    }
}

