/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;

public class DelegatingInputStream
extends InputStream
implements StatsAware {
    private final InputStream delegate;
    private final Stats stats = new Stats();

    public DelegatingInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.delegate.read(b);
        if (result > 0) {
            ++this.stats.bytesRead;
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.delegate.read(b, off, len);
        if (result > 0) {
            this.stats.bytesRead += (long)result;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public boolean isNull() {
        return this.delegate == null;
    }

    @Override
    public Stats stats() {
        return this.stats;
    }
}

