/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.apache.pig.LoadPushDown;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.FieldAlias;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

class PigUtils {
    private static final String MAPPING_NAMES = "es.mapping.names";
    private static final boolean pig11Available = "datetime".equals(DataType.findTypeName((byte)30));

    PigUtils() {
    }

    static String convertDateToES(Object pigDate) {
        return pig11Available ? Pig11OrHigherConverter.convertToES(pigDate) : PigUpTo10Converter.convertToES(pigDate);
    }

    static Object convertDateFromES(String esDate) {
        return pig11Available ? Pig11OrHigherConverter.convertFromES(esDate) : PigUpTo10Converter.convertFromES(esDate);
    }

    static FieldAlias alias(Settings settings) {
        return new FieldAlias(SettingsUtils.aliases(settings.getProperty(MAPPING_NAMES)));
    }

    static String asProjection(Schema schema, Properties props) {
        ArrayList<String> fields = new ArrayList<String>();
        PigUtils.addField(schema, fields, PigUtils.alias(new PropertiesSettings(props)), "");
        return StringUtils.concatenate(fields.toArray(new String[fields.size()]), ",");
    }

    private static void addField(Schema schema, List<String> fields, FieldAlias fa, String currentNode) {
        for (Schema.FieldSchema field : schema.getFields()) {
            if (field.schema != null) {
                PigUtils.addField(schema, fields, fa, currentNode + "." + fa.toES(field.alias));
                continue;
            }
            fields.add(fa.toES(field.alias));
        }
    }

    static String asProjection(LoadPushDown.RequiredFieldList list, Properties props) {
        ArrayList<String> fields = new ArrayList<String>();
        FieldAlias alias = PigUtils.alias(new PropertiesSettings(props));
        for (LoadPushDown.RequiredField field : list.getFields()) {
            PigUtils.addField(field, fields, alias, "");
        }
        return StringUtils.concatenate(fields.toArray(new String[fields.size()]), ",");
    }

    private static void addField(LoadPushDown.RequiredField field, List<String> fields, FieldAlias fa, String currentNode) {
        if (field.getSubFields() != null && !field.getSubFields().isEmpty()) {
            for (LoadPushDown.RequiredField subField : field.getSubFields()) {
                PigUtils.addField(subField, fields, fa, currentNode + "." + fa.toES(subField.getAlias()));
            }
        } else {
            fields.add(fa.toES(field.getAlias()));
        }
    }

    private static abstract class Pig11OrHigherConverter {
        private Pig11OrHigherConverter() {
        }

        static String convertToES(Object pigDate) {
            DateTime dt = (DateTime)pigDate;
            return dt.toString();
        }

        static Object convertFromES(String esDate) {
            return ISODateTimeFormat.dateOptionalTimeParser().parseDateTime(esDate);
        }
    }

    private static abstract class PigUpTo10Converter {
        private PigUpTo10Converter() {
        }

        static String convertToES(Object pigDate) {
            if (pigDate instanceof Number) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(((Number)pigDate).longValue());
                return DatatypeConverter.printDateTime((Calendar)cal);
            }
            if (pigDate instanceof String) {
                return (String)pigDate;
            }
            throw new EsHadoopIllegalArgumentException(String.format("Cannot convert [%s] to date", pigDate));
        }

        static Object convertFromES(String esDate) {
            return DatatypeConverter.parseDateTime((String)esDate).getTimeInMillis();
        }
    }
}

