/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataType;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.pig.PigTuple;
import org.elasticsearch.hadoop.serialization.field.ConstantFieldExtractor;
import org.elasticsearch.hadoop.util.Assert;

public class PigFieldExtractor
extends ConstantFieldExtractor {
    @Override
    protected String extractField(Object target) {
        if (target instanceof PigTuple) {
            PigTuple pt = (PigTuple)target;
            ResourceSchema.ResourceFieldSchema[] fields = pt.getSchema().getSchema().getFields();
            for (int i = 0; i < fields.length; ++i) {
                ResourceSchema.ResourceFieldSchema field = fields[i];
                if (!this.getFieldName().equals(field.getName())) continue;
                byte type = field.getType();
                Assert.isTrue(DataType.isAtomic((byte)type), String.format("Unsupported data type [%s] for field [%s]; use only 'primitives'", DataType.findTypeName((byte)type), this.getFieldName()));
                try {
                    return pt.getTuple().get(i).toString();
                }
                catch (ExecException ex) {
                    throw new EsHadoopIllegalStateException(String.format("Cannot retrieve field [%s]", this.getFieldName()), ex);
                }
            }
        }
        return null;
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
    }
}

