/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.mr.EsOutputFormat;
import org.elasticsearch.hadoop.pig.EsPigInputFormat;
import org.elasticsearch.hadoop.pig.PigBytesConverter;
import org.elasticsearch.hadoop.pig.PigFieldExtractor;
import org.elasticsearch.hadoop.pig.PigTuple;
import org.elasticsearch.hadoop.pig.PigUtils;
import org.elasticsearch.hadoop.pig.PigValueReader;
import org.elasticsearch.hadoop.pig.PigValueWriter;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class EsStorage
extends LoadFunc
implements LoadMetadata,
LoadPushDown,
StoreFuncInterface,
StoreMetadata {
    private static final Log log = LogFactory.getLog(EsStorage.class);
    private final boolean trace = log.isTraceEnabled();
    private Properties properties;
    private String relativeLocation;
    private String signature;
    private ResourceSchema schema;
    private RecordReader<String, Map<?, ?>> reader;
    private RecordWriter<Object, Object> writer;
    private PigTuple pigTuple;
    private List<String> aliasesTupleNames;
    private boolean IS_ES_10;

    public EsStorage() {
        this(new String[0]);
    }

    public EsStorage(String ... configuration) {
        if (!ObjectUtils.isEmpty(configuration)) {
            try {
                this.properties = new Properties();
                for (String string : configuration) {
                    this.properties.load(new StringReader(string));
                }
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalArgumentException("Cannot parse options " + Arrays.toString(configuration), ex);
            }
        }
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.signature = signature;
    }

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        Properties props = this.getUDFProperties();
        if (props.getProperty(ResourceSchema.class.getName()) == null) {
            props.setProperty(ResourceSchema.class.getName(), IOUtils.serializeToBase64((Serializable)s));
        }
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.init(location, job, false);
    }

    private void init(String location, Job job, boolean read) {
        Settings settings = SettingsManager.loadFrom(job.getConfiguration()).merge(this.properties);
        settings = read ? settings.setResourceRead(location) : settings.setResourceWrite(location);
        boolean changed = false;
        InitializationUtils.checkIdForOperation(settings);
        changed |= InitializationUtils.setValueWriterIfNotSet(settings, PigValueWriter.class, log);
        changed |= InitializationUtils.setValueReaderIfNotSet(settings, PigValueReader.class, log);
        changed |= InitializationUtils.setBytesConverterIfNeeded(settings, PigBytesConverter.class, log);
        changed |= InitializationUtils.setFieldExtractorIfNotSet(settings, PigFieldExtractor.class, log);
        this.IS_ES_10 = SettingsUtils.isEs10(settings);
    }

    public OutputFormat<Object, Map<Writable, Writable>> getOutputFormat() throws IOException {
        return new EsOutputFormat();
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
        Properties props = this.getUDFProperties();
        String s = props.getProperty(ResourceSchema.class.getName());
        this.schema = (ResourceSchema)IOUtils.deserializeFromBase64(s);
        this.pigTuple = new PigTuple(this.schema);
    }

    public void putNext(Tuple t) throws IOException {
        this.pigTuple.setTuple(t);
        if (this.trace) {
            log.trace((Object)("Writing out tuple " + t));
        }
        try {
            this.writer.write(null, (Object)this.pigTuple);
        }
        catch (InterruptedException ex) {
            throw new EsHadoopIllegalArgumentException("interrupted", ex);
        }
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
    }

    public void setLocation(String location, Job job) throws IOException {
        this.init(location, job, true);
        Configuration cfg = job.getConfiguration();
        Settings settings = SettingsManager.loadFrom(cfg);
        this.IS_ES_10 = SettingsUtils.isEs10(settings);
        if (settings.getScrollFields() != null) {
            return;
        }
        String fields = this.getUDFProperties().getProperty("es.internal.mr.target.fields");
        if (fields != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found field project [%s] in UDF properties", fields));
            }
            cfg.set("es.internal.mr.target.fields", fields);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"No field projection specified, looking for existing stores...");
        }
        String mapValues = cfg.get("pig.map.stores");
        String reduceValues = cfg.get("pig.reduce.stores");
        List mapStore = Collections.emptyList();
        List reduceStore = Collections.emptyList();
        if (StringUtils.hasText(mapValues)) {
            mapStore = (List)ObjectSerializer.deserialize((String)mapValues);
        }
        if (StringUtils.hasText(reduceValues)) {
            reduceStore = (List)ObjectSerializer.deserialize((String)reduceValues);
        }
        if (mapStore.size() + reduceStore.size() > 1) {
            log.warn((Object)"Too many POstores - cannot properly determine Pig schema");
        } else if (mapStore.size() + reduceStore.size() == 0) {
            log.warn((Object)"No POstores - cannot properly determine Pig schema");
        } else {
            POStore store;
            POStore pOStore = store = reduceStore.isEmpty() ? (POStore)mapStore.get(0) : (POStore)reduceStore.get(0);
            if (store.getSchema() == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Store [%s] defines no schema; falling back to default projection", store));
                }
                return;
            }
            fields = PigUtils.asProjection(store.getSchema(), this.properties);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found field projection [%s] in store %s", fields, store));
            }
            cfg.set("es.internal.mr.target.fields", fields);
            this.getUDFProperties().setProperty("es.internal.mr.target.fields", fields);
        }
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        this.relativeLocation = location;
        return this.relativeLocation;
    }

    public InputFormat getInputFormat() throws IOException {
        return new EsPigInputFormat();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = reader;
        this.aliasesTupleNames = StringUtils.tokenize(this.getUDFProperties().getProperty("es.internal.mr.target.fields"));
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            Map dataMap = (Map)this.reader.getCurrentValue();
            Tuple tuple = TupleFactory.getInstance().newTuple(dataMap.size());
            if (dataMap.isEmpty()) {
                return tuple;
            }
            if (!this.aliasesTupleNames.isEmpty()) {
                for (int i = 0; i < this.aliasesTupleNames.size(); ++i) {
                    if (this.IS_ES_10) {
                        String level;
                        Map result = dataMap;
                        Iterator<String> i$ = StringUtils.tokenize(this.aliasesTupleNames.get(i), ".").iterator();
                        while (i$.hasNext() && (result = result.get(level = i$.next())) != null) {
                        }
                        tuple.set(i, (Object)result);
                        continue;
                    }
                    tuple.set(i, dataMap.get(this.aliasesTupleNames.get(i)));
                }
            } else {
                int i = 0;
                Set entrySet = dataMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    tuple.set(i++, entry.getValue());
                }
            }
            if (this.trace) {
                log.trace((Object)("Reading out tuple " + tuple));
            }
            return tuple;
        }
        catch (InterruptedException ex) {
            throw new IOException("interrupted", ex);
        }
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        String fields = PigUtils.asProjection(requiredFieldList, this.properties);
        this.getUDFProperties().setProperty("es.internal.mr.target.fields", fields);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Given push projection; saving field projection [%s]", fields));
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        return null;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }
}

