/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Progressable;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.hive.HiveBytesArrayWritable;
import org.elasticsearch.hadoop.hive.HiveBytesConverter;
import org.elasticsearch.hadoop.hive.HiveUtils;
import org.elasticsearch.hadoop.hive.HiveValueWriter;
import org.elasticsearch.hadoop.mr.EsOutputFormat;
import org.elasticsearch.hadoop.rest.InitializationUtils;

public class EsHiveOutputFormat
extends EsOutputFormat
implements HiveOutputFormat {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) {
        Settings settings = SettingsManager.loadFrom(jc).merge(tableProperties);
        Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
        InitializationUtils.setValueWriterIfNotSet(settings, HiveValueWriter.class, log);
        InitializationUtils.setBytesConverterIfNeeded(settings, HiveBytesConverter.class, log);
        settings.setResourceWrite(settings.getResourceWrite());
        HiveUtils.init(settings, log);
        return new EsHiveRecordWriter((Configuration)jc, progress);
    }

    static class EsHiveRecordWriter
    extends EsOutputFormat.EsRecordWriter
    implements FileSinkOperator.RecordWriter {
        private final Progressable progress;

        public EsHiveRecordWriter(Configuration cfg, Progressable progress) {
            super(cfg, progress);
            this.progress = progress;
        }

        public void write(Writable w) throws IOException {
            if (!this.initialized) {
                this.initialized = true;
                this.init();
            }
            if (!(w instanceof HiveBytesArrayWritable)) {
                throw new EsHadoopIllegalArgumentException(String.format("Unexpected type; expected [%s], received [%s]", HiveBytesArrayWritable.class, w));
            }
            HiveBytesArrayWritable hbaw = (HiveBytesArrayWritable)w;
            this.client.writeProcessedToIndex(hbaw.getContent());
        }

        public void close(boolean abort) throws IOException {
            super.doClose(this.progress);
        }
    }
}

