/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.elasticsearch.hadoop.serialization.SerializationException;

public abstract class IOUtils {
    public static String serializeToBase64(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray(), (boolean)false, (boolean)true));
    }

    public static <T extends Serializable> T deserializeFromBase64(String data) {
        byte[] rawData = Base64.decodeBase64((byte[])data.getBytes());
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(rawData));
            Object o = ois.readObject();
            ois.close();
            return (T)((Serializable)o);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("cannot deserialize object", ex);
        }
        catch (IOException ex) {
            throw new SerializationException("cannot deserialize object", ex);
        }
    }
}

