/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.elasticsearch.hadoop.rest.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class ParsingUtils {
    public static Parser.Token seek(String path, Parser parser) {
        if (!StringUtils.hasText(path)) {
            return null;
        }
        List<String> tokens = StringUtils.tokenize(path, "/");
        ListIterator<String> li = tokens.listIterator();
        return ParsingUtils.doSeekToken(li.next(), li, parser);
    }

    private static Parser.Token doSeekToken(String targetNode, ListIterator<String> listIterator, Parser parser) {
        Parser.Token token = null;
        while ((token = parser.nextToken()) != null) {
            if (token != Parser.Token.FIELD_NAME) continue;
            if (targetNode.equals(parser.currentName())) {
                if (listIterator.hasNext()) {
                    return ParsingUtils.doSeekToken(listIterator.next(), listIterator, parser);
                }
                return parser.nextToken();
            }
            parser.nextToken();
            parser.skipChildren();
        }
        return null;
    }

    static void add(Map<String, FieldType> fields, Field field, String parentName) {
        if (FieldType.OBJECT == field.type()) {
            if (parentName != null) {
                parentName = parentName + "\\" + field.name();
            }
            for (Field nestedField : field.properties()) {
                ParsingUtils.add(fields, nestedField, parentName);
            }
        } else {
            fields.put(field.name(), field.type());
        }
    }
}

