/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.ValueWriter;

public class JdkValueWriter
implements ValueWriter<Object> {
    protected final boolean writeUnknownTypes;

    public JdkValueWriter() {
        this.writeUnknownTypes = false;
    }

    public JdkValueWriter(boolean writeUnknownTypes) {
        this.writeUnknownTypes = writeUnknownTypes;
    }

    @Override
    public boolean write(Object value, Generator generator) {
        if (value == null) {
            generator.writeNull();
        } else if (value instanceof String) {
            generator.writeString((String)value);
        } else if (value instanceof Integer) {
            generator.writeNumber((Integer)value);
        } else if (value instanceof Long) {
            generator.writeNumber((Long)value);
        } else if (value instanceof Float) {
            generator.writeNumber(((Float)value).floatValue());
        } else if (value instanceof Double) {
            generator.writeNumber((Double)value);
        } else if (value instanceof Short) {
            generator.writeNumber((Short)value);
        } else if (value instanceof Byte) {
            generator.writeNumber((Byte)value);
        } else if (value instanceof Number) {
            generator.writeString(value.toString());
        } else if (value instanceof Boolean) {
            generator.writeBoolean((Boolean)value);
        } else if (value instanceof byte[]) {
            generator.writeBinary((byte[])value);
        } else if (value instanceof Object[]) {
            generator.writeBeginArray();
            for (Object o : (Object[])value) {
                this.write(o, generator);
            }
            generator.writeEndArray();
        } else if (value instanceof Map) {
            generator.writeBeginObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                this.write(entry.getValue(), generator);
            }
            generator.writeEndObject();
        } else if (value instanceof Iterable) {
            generator.writeBeginArray();
            for (Object o : (Iterable)value) {
                this.write(o, generator);
            }
            generator.writeEndArray();
        } else if (value instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            generator.writeString(DatatypeConverter.printDateTime((Calendar)cal));
        } else if (value instanceof Calendar) {
            generator.writeString(DatatypeConverter.printDateTime((Calendar)((Calendar)value)));
        } else if (value instanceof Timestamp) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Timestamp)value).getTime());
            generator.writeString(DatatypeConverter.printDateTime((Calendar)cal));
        } else {
            if (this.writeUnknownTypes) {
                return this.handleUnknown(value, generator);
            }
            return false;
        }
        return true;
    }

    protected boolean handleUnknown(Object value, Generator generator) {
        generator.writeString(value.toString());
        return true;
    }
}

