/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.ValueReader;

public class JdkValueReader
implements ValueReader {
    @Override
    public Object readValue(Parser parser, String value, FieldType esType) {
        switch (esType) {
            case NULL: {
                return this.nullValue(value);
            }
            case STRING: {
                return this.textValue(value);
            }
            case INTEGER: {
                return this.intValue(value);
            }
            case LONG: {
                return this.longValue(value);
            }
            case FLOAT: {
                return this.floatValue(value);
            }
            case DOUBLE: {
                return this.doubleValue(value);
            }
            case BOOLEAN: {
                return this.booleanValue(value);
            }
            case BINARY: {
                return this.binaryValue(parser.binaryValue());
            }
            case DATE: {
                return this.date(value);
            }
            case IP: {
                throw new UnsupportedOperationException("not implemented yet");
            }
            case OBJECT: {
                throw new UnsupportedOperationException("not implemented yet");
            }
        }
        return null;
    }

    @Override
    public Map createMap() {
        return new LinkedHashMap();
    }

    @Override
    public void addToMap(Object map, Object key, Object value) {
        ((Map)map).put(key, value);
    }

    @Override
    public Object createArray(FieldType type) {
        return Collections.emptyList();
    }

    @Override
    public Object addToArray(Object array, List<Object> value) {
        return value;
    }

    protected Object binaryValue(byte[] value) {
        return value;
    }

    protected Object booleanValue(String value) {
        return Boolean.parseBoolean(value);
    }

    protected Object doubleValue(String value) {
        return Double.parseDouble(value);
    }

    protected Object floatValue(String value) {
        return Float.valueOf(Float.parseFloat(value));
    }

    protected Object longValue(String value) {
        return Long.parseLong(value);
    }

    protected Object intValue(String value) {
        return Integer.parseInt(value);
    }

    protected Object textValue(String value) {
        return value;
    }

    protected Object nullValue(String value) {
        return null;
    }

    protected Object date(String value) {
        throw new UnsupportedOperationException("wip");
    }
}

