/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.dto.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.hadoop.serialization.FieldType;

public class Field
implements Serializable {
    private final String name;
    private final FieldType type;
    private final Field[] properties;

    public Field(String name, FieldType type) {
        this(name, type, (Field[])null);
    }

    public Field(String name, FieldType type, Collection<Field> properties) {
        this(name, type, properties != null ? properties.toArray(new Field[properties.size()]) : null);
    }

    Field(String name, FieldType type, Field[] properties) {
        this.name = name;
        this.type = type;
        this.properties = properties;
    }

    public Field[] properties() {
        return this.properties;
    }

    public FieldType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public static Field parseField(Map<String, Object> content) {
        return Field.parseField(content.entrySet().iterator().next(), null);
    }

    public static Map<String, FieldType> toLookupMap(Field field) {
        if (field == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, FieldType> map = new LinkedHashMap<String, FieldType>();
        for (Field nestedField : field.properties()) {
            Field.add(map, nestedField, null);
        }
        return map;
    }

    static void add(Map<String, FieldType> fields, Field field, String parentName) {
        if (FieldType.OBJECT == field.type()) {
            if (parentName != null) {
                parentName = parentName + "." + field.name();
            }
            for (Field nestedField : field.properties()) {
                Field.add(fields, nestedField, parentName);
            }
        } else {
            fields.put(field.name(), field.type());
        }
    }

    private static Field parseField(Map.Entry<String, Object> entry, String previousKey) {
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof Map) {
            Map content = (Map)value;
            Object type = content.get("type");
            if (type instanceof String) {
                return new Field(key, FieldType.parse(type.toString().toUpperCase()));
            }
            ArrayList<Field> fields = new ArrayList<Field>(content.size());
            for (Map.Entry<String, Object> entry2 : content.entrySet()) {
                if (!(entry2.getValue() instanceof Map)) continue;
                Field fl = Field.parseField(entry2, key);
                if (fl.type == FieldType.OBJECT && "properties".equals(fl.name)) {
                    return new Field(key, fl.type, fl.properties);
                }
                fields.add(fl);
            }
            return new Field(key, FieldType.OBJECT, fields);
        }
        throw new IllegalArgumentException("invalid map received " + entry);
    }

    public String toString() {
        return String.format("%s=%s", this.name, this.type == FieldType.OBJECT ? Arrays.toString(this.properties) : this.type);
    }
}

