/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.JsonByteArrayRequestEntity;
import org.elasticsearch.hadoop.rest.dto.Node;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class RestClient
implements Closeable {
    private static final Log log = LogFactory.getLog(RestClient.class);
    private HttpClient client;
    private ObjectMapper mapper = new ObjectMapper();
    private TimeValue scrollKeepAlive;
    private boolean indexReadMissingAsEmpty;

    public RestClient(Settings settings) {
        HttpClientParams params = new HttpClientParams();
        params.setConnectionManagerTimeout(settings.getHttpTimeout());
        this.client = new HttpClient(params);
        HostConfiguration hostConfig = new HostConfiguration();
        String targetUri = settings.getTargetUri();
        try {
            hostConfig.setHost(new URI(targetUri, false));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Invalid target URI " + targetUri, ex);
        }
        this.client.setHostConfiguration(hostConfig);
        this.scrollKeepAlive = TimeValue.timeValueMillis(settings.getScrollKeepAlive());
        this.indexReadMissingAsEmpty = settings.getIndexReadMissingAsEmpty();
    }

    private <T> T get(String q, String string) throws IOException {
        return this.parseContent(this.execute((HttpMethodBase)new GetMethod(q)), string);
    }

    private <T> T parseContent(byte[] content, String string) throws IOException {
        JsonParser jsonParser = this.mapper.getJsonFactory().createJsonParser(content);
        Map map = (Map)this.mapper.readValue(jsonParser, Map.class);
        return (T)(string != null ? map.get(string) : map);
    }

    public void bulk(String index, byte[] buffer, int bufferSize) {
        PostMethod post = new PostMethod(index + "/_bulk");
        post.setRequestEntity((RequestEntity)new JsonByteArrayRequestEntity(buffer, bufferSize));
        post.setContentChunked(false);
        this.execute((HttpMethodBase)post);
    }

    public void refresh(String index) {
        int slash = index.indexOf("/");
        String indx = slash < 0 ? index : index.substring(0, slash);
        this.execute((HttpMethodBase)new PostMethod(indx + "/_refresh"));
    }

    private void create(String q, byte[] value) {
        PostMethod post = new PostMethod(q);
        post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(value));
        this.execute((HttpMethodBase)post);
    }

    public void deleteIndex(String index) {
        this.execute((HttpMethodBase)new DeleteMethod(index));
    }

    public List<List<Map<String, Object>>> targetShards(String query) throws IOException {
        List shardsJson = null;
        if (this.indexReadMissingAsEmpty) {
            GetMethod get = new GetMethod(query);
            byte[] content = this.execute((HttpMethodBase)get, false);
            shardsJson = get.getStatusCode() == 404 ? Collections.emptyList() : (List)this.parseContent(content, "shards");
        } else {
            shardsJson = (List)this.get(query, "shards");
        }
        return shardsJson;
    }

    public Map<String, Node> getNodes() throws IOException {
        Map nodesData = (Map)this.get("_nodes", "nodes");
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (Map.Entry entry : nodesData.entrySet()) {
            Node node = new Node((String)entry.getKey(), (Map)entry.getValue());
            nodes.put((String)entry.getKey(), node);
        }
        return nodes;
    }

    public Map<String, Object> getMapping(String query) throws IOException {
        return (Map)this.get(query, null);
    }

    @Override
    public void close() {
        HttpConnectionManager manager = this.client.getHttpConnectionManager();
        if (manager instanceof SimpleHttpConnectionManager) {
            try {
                ((SimpleHttpConnectionManager)manager).closeIdleConnections(0L);
            }
            catch (NullPointerException npe) {
            }
            catch (Exception ex) {
                log.warn((Object)"Exception closing underlying HTTP manager", (Throwable)ex);
            }
        }
    }

    byte[] execute(HttpMethodBase method) {
        return this.execute(method, true);
    }

    byte[] execute(HttpMethodBase method, boolean checkStatus) {
        try {
            int status = this.client.executeMethod((HttpMethod)method);
            if (checkStatus && status >= 207) {
                String body;
                try {
                    body = method.getResponseBodyAsString();
                }
                catch (IOException ex) {
                    body = "";
                }
                throw new IllegalStateException(String.format("[%s] on [%s] failed; server[%s] returned [%s]", method.getName(), method.getURI(), this.client.getHostConfiguration().getHostURL(), body));
            }
            byte[] body = method.getResponseBody();
            return body;
        }
        catch (IOException io) {
            String target;
            try {
                target = method.getURI().toString();
            }
            catch (IOException ex) {
                target = method.getPath();
            }
            throw new IllegalStateException(String.format("Cannot get response body for [%s][%s]", method.getName(), target));
        }
        finally {
            method.releaseConnection();
        }
    }

    public String[] scan(String query) throws IOException {
        Map scan = (Map)this.get(query, null);
        String[] data = new String[]{scan.get("_scroll_id").toString(), ((Map)scan.get("hits")).get("total").toString()};
        return data;
    }

    public byte[] scroll(String scrollId) throws IOException {
        PostMethod post = new PostMethod("_search/scroll?scroll=" + this.scrollKeepAlive.toString());
        post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(scrollId.getBytes(StringUtils.UTF_8)));
        return this.execute((HttpMethodBase)post);
    }

    public boolean exists(String indexOrType) {
        HeadMethod headMethod = new HeadMethod(indexOrType);
        this.execute((HttpMethodBase)headMethod, false);
        return headMethod.getStatusCode() == 200;
    }

    public void putMapping(String index, String mapping, byte[] bytes) {
        this.execute((HttpMethodBase)new PutMethod(index), false);
        PutMethod put = new PutMethod(mapping);
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(bytes));
        this.execute((HttpMethodBase)put);
    }
}

