/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.util.List;
import java.util.Map;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.pig.DateConverter;
import org.elasticsearch.hadoop.pig.FieldAlias;
import org.elasticsearch.hadoop.pig.PigTuple;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.ValueWriter;
import org.elasticsearch.hadoop.util.StringUtils;

public class PigValueWriter
implements ValueWriter<PigTuple>,
SettingsAware {
    private final boolean writeUnknownTypes;
    private FieldAlias alias = new FieldAlias();

    public PigValueWriter() {
        this.writeUnknownTypes = false;
    }

    @Override
    public void setSettings(Settings settings) {
        this.alias = FieldAlias.load(settings);
    }

    @Override
    public boolean write(PigTuple type, Generator generator) {
        return this.write(type.getTuple(), type.getSchema(), generator, false);
    }

    public boolean write(Object object, ResourceSchema.ResourceFieldSchema field, Generator generator, boolean writeFieldName) {
        byte type;
        byte by = type = field != null ? field.getType() : DataType.findType((Object)object);
        if (writeFieldName) {
            generator.writeFieldName(this.alias.toES(field.getName()));
        }
        if (object == null) {
            generator.writeNull();
            return true;
        }
        switch (type) {
            case -1: 
            case 0: {
                return this.handleUnknown(object, field, generator);
            }
            case 1: {
                generator.writeNull();
                break;
            }
            case 5: {
                generator.writeBoolean((Boolean)object);
                break;
            }
            case 10: {
                generator.writeNumber(((Number)object).intValue());
                break;
            }
            case 15: {
                generator.writeNumber(((Number)object).longValue());
                break;
            }
            case 20: {
                generator.writeNumber(((Number)object).floatValue());
                break;
            }
            case 25: {
                generator.writeNumber(((Number)object).doubleValue());
                break;
            }
            case 6: {
                generator.writeNumber((Byte)object);
                break;
            }
            case 55: {
                generator.writeString(object.toString());
                break;
            }
            case 50: {
                generator.writeBinary(((DataByteArray)object).get());
                break;
            }
            case 30: {
                generator.writeString(DateConverter.convertToES(object));
                break;
            }
            case 100: {
                ResourceSchema nestedSchema = field.getSchema();
                if (nestedSchema == null) {
                    generator.writeBeginObject();
                    generator.writeEndObject();
                    break;
                }
                ResourceSchema.ResourceFieldSchema[] nestedFields = nestedSchema.getFields();
                generator.writeBeginObject();
                int index = 0;
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    generator.writeFieldName(this.alias.toES(entry.getKey().toString()));
                    this.write(entry.getValue(), nestedFields[index++], generator, false);
                }
                generator.writeEndObject();
                break;
            }
            case 110: {
                ResourceSchema nestedSchema = field.getSchema();
                if (nestedSchema == null) {
                    generator.writeBeginObject();
                    generator.writeEndObject();
                    break;
                }
                ResourceSchema.ResourceFieldSchema[] nestedFields = nestedSchema.getFields();
                List tuples = ((Tuple)object).getAll();
                generator.writeBeginObject();
                for (int i = 0; i < nestedFields.length; ++i) {
                    String name = nestedFields[i].getName();
                    name = StringUtils.hasText(name) ? this.alias.toES(name) : Integer.toString(i);
                    generator.writeFieldName(name);
                    this.write(tuples.get(i), nestedFields[i], generator, false);
                }
                generator.writeEndObject();
                break;
            }
            case 120: {
                ResourceSchema nestedSchema = field.getSchema();
                if (nestedSchema == null) {
                    generator.writeBeginArray();
                    generator.writeEndArray();
                    break;
                }
                ResourceSchema.ResourceFieldSchema bagType = nestedSchema.getFields()[0];
                generator.writeBeginArray();
                for (Tuple tuple : (DataBag)object) {
                    this.write(tuple, bagType, generator, false);
                }
                generator.writeEndArray();
                break;
            }
            default: {
                if (this.writeUnknownTypes) {
                    return this.handleUnknown(object, field, generator);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean handleUnknown(Object value, ResourceSchema.ResourceFieldSchema field, Generator generator) {
        return false;
    }
}

