/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.elasticsearch.hadoop.cfg.ConfigurationOptions;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.mr.WritableValueWriter;
import org.elasticsearch.hadoop.rest.BufferedRestClient;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.serialization.SerializationUtils;
import org.elasticsearch.hadoop.util.Assert;

public class ESOutputFormat
extends OutputFormat
implements org.apache.hadoop.mapred.OutputFormat,
ConfigurationOptions {
    private static Log log = LogFactory.getLog(ESOutputFormat.class);

    public org.apache.hadoop.mapreduce.RecordWriter getRecordWriter(TaskAttemptContext context) {
        return (org.apache.hadoop.mapreduce.RecordWriter)this.getRecordWriter(null, (JobConf)context.getConfiguration(), null, (Progressable)context);
    }

    public void checkOutputSpecs(JobContext context) throws IOException {
        this.init(context.getConfiguration());
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new ESOutputCommitter();
    }

    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) {
        return new ESRecordWriter((Configuration)job);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf cfg) throws IOException {
        this.init((Configuration)cfg);
    }

    private void init(Configuration cfg) throws IOException {
        Settings settings = SettingsManager.loadFrom(cfg);
        Assert.hasText(settings.getTargetResource(), String.format("No resource ['%s'] (index/query/location) specified", "es.resource"));
        BufferedRestClient client = null;
        InitializationUtils.checkIndexExistence(settings, client);
        log.info((Object)String.format("Preparing to write/index to [%s][%s]", settings.getTargetUri(), settings.getTargetResource()));
    }

    protected static class ESRecordWriter
    extends org.apache.hadoop.mapreduce.RecordWriter
    implements RecordWriter {
        protected final BufferedRestClient client;
        private final String uri;
        private final String resource;

        public ESRecordWriter(Configuration cfg) {
            Settings settings = SettingsManager.loadFrom(cfg);
            SerializationUtils.setValueWriterIfNotSet(settings, WritableValueWriter.class, log);
            this.client = new BufferedRestClient(settings);
            this.uri = settings.getTargetUri();
            this.resource = settings.getTargetResource();
        }

        public void write(Object key, Object value) throws IOException {
            this.client.addToIndex(value);
        }

        public void close(TaskAttemptContext context) throws IOException {
            this.close((Reporter)null);
        }

        public void close(Reporter reporter) throws IOException {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Closing RecordWriter [%s][%s]", this.uri, this.resource));
            }
            this.client.close();
        }
    }

    public static class ESOldAPIOutputCommitter
    extends org.apache.hadoop.mapred.OutputCommitter {
        public void setupJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        }

        public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
            return false;
        }

        public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
        }

        public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
        }

        @Deprecated
        public void cleanupJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
        }
    }

    public static class ESOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) throws IOException {
        }

        @Deprecated
        public void cleanupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
        }
    }
}

