/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.elasticsearch.hadoop.cfg.ConfigurationOptions;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.mr.WritableValueReader;
import org.elasticsearch.hadoop.rest.BufferedRestClient;
import org.elasticsearch.hadoop.rest.QueryBuilder;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.dto.Node;
import org.elasticsearch.hadoop.rest.dto.Shard;
import org.elasticsearch.hadoop.rest.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.SerializationUtils;
import org.elasticsearch.hadoop.serialization.ValueReader;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class ESInputFormat<K, V>
extends InputFormat<K, V>
implements org.apache.hadoop.mapred.InputFormat<K, V>,
ConfigurationOptions {
    private static Log log = LogFactory.getLog(ESInputFormat.class);

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        JobConf conf = (JobConf)context.getConfiguration();
        return Arrays.asList((InputSplit[])this.getSplits(conf, conf.getNumMapTasks()));
    }

    public ShardRecordReader createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new WritableShardRecordReader();
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Settings settings = SettingsManager.loadFrom(job);
        BufferedRestClient client = new BufferedRestClient(settings);
        Map<Shard, Node> targetShards = client.getTargetShards();
        String savedMapping = null;
        if (!targetShards.isEmpty()) {
            Field mapping = client.getMapping();
            savedMapping = IOUtils.serializeToBase64(mapping);
            log.info((Object)String.format("Discovered mapping {%s} for [%s]", mapping, settings.getTargetResource()));
        }
        client.close();
        if (settings.getIndexReadMissingAsEmpty() && targetShards.isEmpty()) {
            log.info((Object)String.format("Index [%s] missing - treating it as empty", settings.getTargetResource()));
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Creating splits for shards " + targetShards));
        }
        org.apache.hadoop.mapred.InputSplit[] splits = new ShardInputSplit[targetShards.size()];
        int index = 0;
        for (Map.Entry<Shard, Node> entry : targetShards.entrySet()) {
            Shard shard = entry.getKey();
            Node node = entry.getValue();
            splits[index++] = new ShardInputSplit(node.getIpAddress(), node.getHttpPort(), node.getId(), node.getName(), shard.getName(), savedMapping);
        }
        log.info((Object)String.format("Created [%d] shard-splits", splits.length));
        return splits;
    }

    public ShardRecordReader getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) {
        return new WritableShardRecordReader(split, (Configuration)job, reporter);
    }

    protected static class WritableShardRecordReader
    extends ShardRecordReader<Text, MapWritable> {
        public WritableShardRecordReader() {
        }

        public WritableShardRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public Text createKey() {
            return new Text();
        }

        @Override
        public MapWritable createValue() {
            return new MapWritable();
        }

        @Override
        protected Text setCurrentKey(Text oldApiKey, Text newApiKey, Object object) {
            String val = object.toString();
            if (oldApiKey == null) {
                oldApiKey = new Text();
                oldApiKey.set(val);
            }
            if (newApiKey != null) {
                newApiKey.set(val);
            }
            return oldApiKey;
        }

        @Override
        protected MapWritable setCurrentValue(MapWritable oldApiValue, MapWritable newApiKey, Object object) {
            MapWritable val = (MapWritable)object;
            if (newApiKey != null) {
                newApiKey.clear();
                newApiKey.putAll((Map)val);
            }
            return val;
        }
    }

    protected static abstract class ShardRecordReader<K, V>
    extends RecordReader<K, V>
    implements org.apache.hadoop.mapred.RecordReader<K, V> {
        private int read = 0;
        private ShardInputSplit esSplit;
        private ScrollReader scrollReader;
        private BufferedRestClient client;
        private QueryBuilder queryBuilder;
        private ScrollQuery result;
        private K currentKey;
        private V currentValue;
        private long size = 0L;

        public ShardRecordReader() {
        }

        public ShardRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration job, Reporter reporter) {
            reporter.setStatus(split.toString());
            this.init((ShardInputSplit)split, job);
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
            context.setStatus(split.toString());
            this.init((ShardInputSplit)split, context.getConfiguration());
        }

        void init(ShardInputSplit esSplit, Configuration cfg) {
            Settings settings = SettingsManager.loadFrom(cfg);
            settings.cleanUri().setHost(esSplit.nodeIp).setPort(esSplit.httpPort);
            this.esSplit = esSplit;
            SerializationUtils.setValueReaderIfNotSet(settings, WritableValueReader.class, log);
            ValueReader reader = SerializationUtils.instantiateValueReader(settings);
            String mappingData = esSplit.mapping;
            Field mapping = null;
            if (StringUtils.hasText(mappingData)) {
                mapping = (Field)IOUtils.deserializeFromBase64(mappingData);
            } else {
                log.warn((Object)String.format("No mapping found for [%s] - either no index exists or the split configuration has been corrupted", new Object[]{esSplit}));
            }
            this.scrollReader = new ScrollReader(reader, mapping);
            this.client = new BufferedRestClient(settings);
            this.queryBuilder = QueryBuilder.query(settings).shard(esSplit.shardId).onlyNode(esSplit.nodeId);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Initializing RecordReader for [%s]", new Object[]{esSplit}));
            }
        }

        public boolean nextKeyValue() throws IOException {
            if (this.currentKey == null) {
                this.currentKey = this.createKey();
            }
            if (this.currentValue == null) {
                this.currentValue = this.createValue();
            }
            return this.next(this.currentKey, this.currentValue);
        }

        public K getCurrentKey() throws IOException {
            return this.currentKey;
        }

        public V getCurrentValue() {
            return this.currentValue;
        }

        public float getProgress() {
            return this.size == 0L ? 0.0f : (float)this.getPos() / (float)this.size;
        }

        public void close() throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Closing RecordReader for [%s]", new Object[]{this.esSplit}));
            }
            if (this.result != null) {
                this.result.close();
                this.result = null;
            }
            this.client.close();
        }

        public boolean next(K key, V value) throws IOException {
            boolean hasNext;
            if (this.result == null) {
                this.result = this.queryBuilder.build(this.client, this.scrollReader);
                this.size = this.result.getSize();
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Received scroll [%s],  size [%d] for query [%s]", this.result, this.size, this.queryBuilder));
                }
            }
            if (!(hasNext = this.result.hasNext())) {
                return false;
            }
            Object[] next = this.result.next();
            this.currentKey = this.setCurrentKey(this.currentKey, key, next[0]);
            this.currentValue = this.setCurrentValue(this.currentValue, value, next[1]);
            ++this.read;
            return true;
        }

        public abstract K createKey();

        public abstract V createValue();

        protected abstract K setCurrentKey(K var1, K var2, Object var3);

        protected abstract V setCurrentValue(V var1, V var2, Object var3);

        public long getPos() {
            return this.read;
        }
    }

    protected static class ShardInputSplit
    extends InputSplit
    implements org.apache.hadoop.mapred.InputSplit {
        private String nodeIp;
        private int httpPort;
        private String nodeId;
        private String nodeName;
        private String shardId;
        private String mapping;

        public ShardInputSplit() {
        }

        public ShardInputSplit(String nodeIp, int httpPort, String nodeId, String nodeName, Integer shard, String mapping) {
            this.nodeIp = nodeIp;
            this.httpPort = httpPort;
            this.nodeId = nodeId;
            this.nodeName = nodeName;
            this.shardId = shard.toString();
            this.mapping = mapping;
        }

        public long getLength() {
            return 1L;
        }

        public String[] getLocations() {
            return new String[]{this.nodeIp};
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.nodeIp);
            out.writeInt(this.httpPort);
            out.writeUTF(this.nodeId);
            out.writeUTF(this.nodeName);
            out.writeUTF(this.shardId);
            out.writeUTF(this.mapping);
        }

        public void readFields(DataInput in) throws IOException {
            this.nodeIp = in.readUTF();
            this.httpPort = in.readInt();
            this.nodeId = in.readUTF();
            this.nodeName = in.readUTF();
            this.shardId = in.readUTF();
            this.mapping = in.readUTF();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ShardInputSplit [node=[").append(this.nodeId).append("/").append(this.nodeName).append("|").append(this.nodeIp).append(":").append(this.httpPort).append("],shard=").append(this.shardId).append("]");
            return builder.toString();
        }
    }
}

