/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.elasticsearch.hadoop.hive.FieldAlias;
import org.elasticsearch.hadoop.util.StringUtils;

abstract class HiveUtils {
    HiveUtils() {
    }

    static StandardStructObjectInspector structObjectInspector(Properties tableProperties) {
        List<String> columnNames = StringUtils.tokenize(tableProperties.getProperty("columns"), ",");
        ArrayList colTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)tableProperties.getProperty("columns.types"));
        ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>();
        for (TypeInfo typeInfo : colTypes) {
            inspectors.add(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
    }

    static StructTypeInfo typeInfo(StructObjectInspector inspector) {
        return (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)inspector);
    }

    static FieldAlias alias(Properties tableProperties) {
        List<String> aliases = StringUtils.tokenize(tableProperties.getProperty("es.mapping.names"), ",");
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        if (aliases != null) {
            for (String string : aliases) {
                int index = (string = string.trim()).indexOf(":");
                if (index <= 0) continue;
                String key = string.substring(0, index);
                aliasMap.put(key, string.substring(index + 1));
                aliasMap.put(key.toLowerCase(), string.substring(index + 1));
            }
        }
        List<String> columnNames = StringUtils.tokenize(tableProperties.getProperty("columns"), ",");
        for (int i = 0; i < columnNames.size(); ++i) {
            String alias;
            String colName = columnNames.get(i);
            if (aliases != null && (alias = (String)aliasMap.get(colName)) != null) {
                colName = alias;
            }
            aliasMap.put("_col" + i, colName);
        }
        return new FieldAlias(aliasMap);
    }
}

