/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class FastBytesWritable
extends BinaryComparable
implements WritableComparable<BinaryComparable> {
    private int size;
    private byte[] bytes;

    public FastBytesWritable() {
        this.bytes = null;
    }

    public FastBytesWritable(byte[] bytes, int size) {
        this.set(bytes, size);
    }

    public int getLength() {
        return this.size;
    }

    public void set(byte[] bytes, int size) {
        this.bytes = bytes;
        this.size = size;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void readFields(DataInput in) throws IOException {
        this.size = in.readInt();
        in.readFully(this.bytes, 0, this.size);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size);
        out.write(this.bytes, 0, this.size);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object right_obj) {
        if (right_obj instanceof FastBytesWritable) {
            return super.equals(right_obj);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(3 * this.size);
        for (int idx = 0; idx < this.size; ++idx) {
            String num;
            if (idx != 0) {
                sb.append(' ');
            }
            if ((num = Integer.toHexString(0xFF & this.bytes[idx])).length() < 2) {
                sb.append('0');
            }
            sb.append(num);
        }
        return sb.toString();
    }

    static {
        WritableComparator.define(FastBytesWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(FastBytesWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return Comparator.compareBytes((byte[])b1, (int)(s1 + 4), (int)(l1 - 4), (byte[])b2, (int)(s2 + 4), (int)(l2 - 4));
        }
    }
}

