/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.hive.FastBytesWritable;
import org.elasticsearch.hadoop.hive.FieldAlias;
import org.elasticsearch.hadoop.hive.HiveType;
import org.elasticsearch.hadoop.hive.HiveUtils;
import org.elasticsearch.hadoop.hive.HiveValueWriter;
import org.elasticsearch.hadoop.serialization.ContentBuilder;
import org.elasticsearch.hadoop.serialization.ValueWriter;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;

public class ESSerDe
implements SerDe {
    private StructObjectInspector inspector;
    private BytesArray scratchPad = new BytesArray(512);
    private ValueWriter<HiveType> valueWriter;
    private HiveType hiveType = new HiveType(null, null);
    private FastBytesWritable result = new FastBytesWritable();
    private StructTypeInfo structTypeInfo;
    private FieldAlias alias;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.inspector = HiveUtils.structObjectInspector(tbl);
        this.structTypeInfo = HiveUtils.typeInfo(this.inspector);
        this.alias = HiveUtils.alias(tbl);
        this.valueWriter = new HiveValueWriter(this.alias);
    }

    public Object deserialize(Writable blob) throws SerDeException {
        if (blob == null || blob instanceof NullWritable) {
            return null;
        }
        return ESSerDe.hiveFromWritable((TypeInfo)this.structTypeInfo, blob, this.alias);
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Class<? extends Writable> getSerializedClass() {
        return FastBytesWritable.class;
    }

    public Writable serialize(Object data, ObjectInspector objInspector) throws SerDeException {
        this.scratchPad.reset();
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(this.scratchPad);
        this.hiveType.setObjectInspector(objInspector);
        this.hiveType.setObject(data);
        ContentBuilder.generate(bos, this.valueWriter).value(this.hiveType).flush().close();
        this.result.set(this.scratchPad.bytes(), this.scratchPad.size());
        return this.result;
    }

    static Object hiveFromWritable(TypeInfo type, Writable data, FieldAlias alias) {
        if (data == null || data instanceof NullWritable) {
            return null;
        }
        switch (type.getCategory()) {
            case LIST: {
                ListTypeInfo listType = (ListTypeInfo)type;
                TypeInfo listElementType = listType.getListElementTypeInfo();
                ArrayWritable aw = (ArrayWritable)data;
                ArrayList<Object> list = new ArrayList<Object>();
                for (Writable writable : aw.get()) {
                    list.add(ESSerDe.hiveFromWritable(listElementType, writable, alias));
                }
                return list;
            }
            case MAP: {
                MapTypeInfo mapType = (MapTypeInfo)type;
                MapWritable mw = (MapWritable)data;
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                for (Map.Entry entry : mw.entrySet()) {
                    map.put(ESSerDe.hiveFromWritable(mapType.getMapKeyTypeInfo(), (Writable)entry.getKey(), alias), ESSerDe.hiveFromWritable(mapType.getMapValueTypeInfo(), (Writable)entry.getValue(), alias));
                }
                return map;
            }
            case STRUCT: {
                StructTypeInfo structType = (StructTypeInfo)type;
                ArrayList names = structType.getAllStructFieldNames();
                ArrayList info = structType.getAllStructFieldTypeInfos();
                ArrayList<Object> struct = new ArrayList<Object>();
                MapWritable map = (MapWritable)data;
                Text reuse = new Text();
                for (int index = 0; index < names.size(); ++index) {
                    reuse.set(alias.toES((String)names.get(index)));
                    struct.add(ESSerDe.hiveFromWritable((TypeInfo)info.get(index), map.get((Object)reuse), alias));
                }
                return struct;
            }
            case UNION: {
                throw new UnsupportedOperationException("union not yet supported");
            }
        }
        return data;
    }
}

