/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.elasticsearch.hadoop.mr.ESInputFormat;

public class ESHiveInputFormat
extends ESInputFormat<Text, MapWritable> {
    public FileSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        InputSplit[] shardSplits = super.getSplits(job, numSplits);
        FileSplit[] wrappers = new FileSplit[shardSplits.length];
        Path path = new Path(job.get("location"));
        for (int i = 0; i < wrappers.length; ++i) {
            wrappers[i] = new ESHiveSplit(shardSplits[i], path);
        }
        return wrappers;
    }

    @Override
    public ESInputFormat.ShardRecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) {
        return new ESInputFormat.WritableShardRecordReader(((ESHiveSplit)split).delegate, (Configuration)job, reporter);
    }

    static class ESHiveSplit
    extends FileSplit {
        InputSplit delegate;
        private Path path;

        ESHiveSplit() {
            this(new ESInputFormat.ShardInputSplit(), null);
        }

        ESHiveSplit(InputSplit delegate, Path path) {
            super(path, 0L, 0L, (String[])null);
            this.delegate = delegate;
            this.path = path;
        }

        public long getLength() {
            return 1L;
        }

        public String[] getLocations() throws IOException {
            return this.delegate.getLocations();
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.path.toString());
            this.delegate.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.path = new Path(Text.readString((DataInput)in));
            this.delegate.readFields(in);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public Path getPath() {
            return this.path;
        }
    }
}

