/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cfg;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.elasticsearch.hadoop.cfg.HadoopSettings;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;

public abstract class SettingsManager {
    private static final Class<?> HADOOP_CONFIGURATION;

    public static Settings loadFrom(Object configuration) {
        if (configuration instanceof Properties) {
            return new PropertiesSettings((Properties)configuration);
        }
        if (HADOOP_CONFIGURATION != null && HADOOP_CONFIGURATION.isInstance(configuration)) {
            return FromHadoopConfiguration.create(configuration);
        }
        throw new IllegalArgumentException("Don't know how to create Settings from configuration " + configuration);
    }

    static {
        Class<?> cfgClass = null;
        try {
            cfgClass = Class.forName("org.apache.hadoop.conf.Configuration", false, SettingsManager.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        HADOOP_CONFIGURATION = cfgClass;
    }

    private static abstract class FromHadoopConfiguration {
        private FromHadoopConfiguration() {
        }

        public static Settings create(Object cfg) {
            return new HadoopSettings((Configuration)cfg);
        }
    }
}

