/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cfg;

import java.util.Enumeration;
import java.util.Properties;
import org.elasticsearch.hadoop.cfg.InternalConfigurationOptions;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.Booleans;
import org.elasticsearch.hadoop.util.unit.ByteSizeValue;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public abstract class Settings
implements InternalConfigurationOptions {
    private String host;
    private int port;
    private String targetResource;

    public String getHost() {
        return StringUtils.hasText(this.host) ? this.host : this.getProperty("es.host", "localhost");
    }

    public int getPort() {
        return this.port > 0 ? this.port : Integer.valueOf(this.getProperty("es.port", "9200"));
    }

    public long getHttpTimeout() {
        return TimeValue.parseTimeValue(this.getProperty("es.http.timeout", "1m")).getMillis();
    }

    public int getBatchSizeInBytes() {
        return ByteSizeValue.parseBytesSizeValue(this.getProperty("es.batch.size.bytes", "10mb")).bytesAsInt();
    }

    public int getBatchSizeInEntries() {
        return Integer.valueOf(this.getProperty("es.batch.size.entries", "0"));
    }

    public boolean getBatchRefreshAfterWrite() {
        return Booleans.parseBoolean(this.getProperty("es.batch.write.refresh", "true"));
    }

    public long getScrollKeepAlive() {
        return TimeValue.parseTimeValue(this.getProperty("es.scroll.keepalive", "10m")).getMillis();
    }

    public long getScrollSize() {
        return Long.valueOf(this.getProperty("es.scroll.size", "50"));
    }

    public String getSerializerValueWriterClassName() {
        return this.getProperty("es.ser.writer.class", null);
    }

    public String getSerializerValueReaderClassName() {
        return this.getProperty("es.ser.reader.class", null);
    }

    public boolean getIndexAutoCreate() {
        return Booleans.parseBoolean(this.getProperty("es.index.auto.create", "yes"));
    }

    public boolean getIndexReadMissingAsEmpty() {
        return Booleans.parseBoolean(this.getProperty("es.index.read.missing.as.empty", "false"));
    }

    public String getTargetUri() {
        String address = this.getProperty("es.internal.mr.target.uri");
        return StringUtils.hasText(address) ? address : "http://" + this.getHost() + ":" + this.getPort() + "/";
    }

    public Settings setHost(String host) {
        this.host = host;
        return this;
    }

    public Settings setPort(int port) {
        this.port = port;
        return this;
    }

    public Settings setResource(String index) {
        this.targetResource = index;
        return this;
    }

    public String getTargetResource() {
        String resource = this.getProperty("es.internal.mr.target.resource");
        return StringUtils.hasText(this.targetResource) ? this.targetResource : (StringUtils.hasText(resource) ? resource : this.getProperty("es.resource"));
    }

    public Settings cleanUri() {
        this.setProperty("es.internal.mr.target.uri", "");
        return this;
    }

    public Settings clean() {
        this.setProperty("es.internal.mr.target.resource", "");
        this.cleanUri();
        return this;
    }

    public void save() {
        String targetUri = this.getTargetUri();
        String resource = this.getTargetResource();
        Assert.hasText(targetUri, "No address specified");
        Assert.hasText(resource, String.format("No resource (index/query/location) ['%s'] specified", "es.resource"));
        this.setProperty("es.internal.mr.target.uri", targetUri);
        this.setProperty("es.internal.mr.target.resource", resource);
    }

    protected String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (!StringUtils.hasText(value)) {
            return defaultValue;
        }
        return value;
    }

    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    public Settings merge(Properties properties) {
        if (properties == null) {
            return this;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        Object prop = null;
        while (propertyNames.hasMoreElements()) {
            prop = propertyNames.nextElement();
            if (!(prop instanceof String)) continue;
            Object value = properties.get(prop);
            this.setProperty(prop, value.toString());
        }
        return this;
    }
}

