/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.flow.Flow;
import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cascading.ESHadoopTap;
import org.elasticsearch.hadoop.cascading.ESLocalTap;

public class ESTap
extends Tap<Object, Object, Object> {
    private static Log log = LogFactory.getLog(ESTap.class);
    private String resource;
    private boolean runningInHadoop = false;
    private Tap actualTap;
    private Fields fields;
    private String host;
    private int port;

    public ESTap(String resource) {
        this(resource, null);
    }

    public ESTap(String host, int port, String resource) {
        this(host, port, resource, null);
    }

    public ESTap(String resource, Fields fields) {
        this(null, -1, resource, fields);
    }

    public ESTap(String host, int port, String resource, Fields fields) {
        this.resource = resource;
        this.host = host;
        this.port = port;
        this.fields = fields;
    }

    public void flowConfInit(Flow<Object> flow) {
        this.initInnerTapIfNotSet(flow, "cascading.flow.hadoop.HadoopFlow");
    }

    public boolean isSink() {
        return true;
    }

    public boolean isSource() {
        return true;
    }

    public String getIdentifier() {
        return this.resource;
    }

    public void sourceConfInit(FlowProcess<Object> flowProcess, Object conf) {
        this.initInnerTapIfNotSetFromFlowProcess(flowProcess);
        this.actualTap.sourceConfInit(flowProcess, conf);
    }

    public void sinkConfInit(FlowProcess<Object> flowProcess, Object conf) {
        this.initInnerTapIfNotSetFromFlowProcess(flowProcess);
        this.actualTap.sinkConfInit(flowProcess, conf);
    }

    public TupleEntryIterator openForRead(FlowProcess<Object> flowProcess, Object input) throws IOException {
        this.initInnerTapIfNotSetFromFlowProcess(flowProcess);
        return this.actualTap.openForRead(flowProcess, input);
    }

    public TupleEntryCollector openForWrite(FlowProcess<Object> flowProcess, Object output) throws IOException {
        this.initInnerTapIfNotSetFromFlowProcess(flowProcess);
        return this.actualTap.openForWrite(flowProcess, output);
    }

    public boolean createResource(Object conf) throws IOException {
        return this.actualTap.createResource(conf);
    }

    public boolean deleteResource(Object conf) throws IOException {
        return this.actualTap.deleteResource(conf);
    }

    public boolean resourceExists(Object conf) throws IOException {
        return this.actualTap.resourceExists(conf);
    }

    public long getModifiedTime(Object conf) throws IOException {
        return this.actualTap.getModifiedTime(conf);
    }

    public boolean isEquivalentTo(FlowElement element) {
        return this.actualTap.isEquivalentTo(element);
    }

    public String toString() {
        return this.actualTap != null ? this.actualTap.toString() : ((Object)((Object)this)).getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[not initialized]";
    }

    private void initInnerTapIfNotSetFromFlowProcess(FlowProcess<Object> target) {
        this.initInnerTapIfNotSet(target, "cascading.flow.hadoop.HadoopFlowProcess");
    }

    private void initInnerTapIfNotSet(Object target, String hadoopTypeName) {
        if (this.actualTap != null) {
            return;
        }
        Class<?> clz = null;
        try {
            clz = Class.forName(hadoopTypeName, false, ((Object)((Object)this)).getClass().getClassLoader());
            if (clz.isInstance(target)) {
                this.runningInHadoop = true;
            }
        }
        catch (ClassNotFoundException e) {
            this.runningInHadoop = false;
        }
        this.actualTap = this.runningInHadoop ? new ESHadoopTap(this.host, this.port, this.resource, this.fields) : new ESLocalTap(this.host, this.port, this.resource, this.fields);
        this.setScheme(this.actualTap.getScheme());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Detected %s environment; initializing [%s]", this.runningInHadoop ? "Hadoop" : "local", this.actualTap.getClass().getSimpleName()));
        }
    }
}

