/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeCollector;
import cascading.tuple.TupleEntrySchemeIterator;
import java.io.IOException;
import java.util.Properties;
import org.elasticsearch.hadoop.cascading.ESLocalScheme;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.rest.BufferedRestClient;
import org.elasticsearch.hadoop.rest.QueryBuilder;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.serialization.JdkValueReader;
import org.elasticsearch.hadoop.serialization.ScrollReader;

class ESLocalTap
extends Tap<Properties, ScrollQuery, Object> {
    private String target;
    private BufferedRestClient client;

    public ESLocalTap(String host, int port, String resource, Fields fields) {
        this.target = resource;
        this.setScheme(new ESLocalScheme(host, port, resource, fields));
    }

    public String getIdentifier() {
        return this.target;
    }

    public TupleEntryIterator openForRead(FlowProcess<Properties> flowProcess, ScrollQuery input) throws IOException {
        Settings settings = SettingsManager.loadFrom(flowProcess.getConfigCopy());
        this.client = new BufferedRestClient(settings);
        if (input == null) {
            input = QueryBuilder.query(this.target).build(this.client, new ScrollReader(new JdkValueReader(), null));
        }
        return new TupleEntrySchemeIterator(flowProcess, this.getScheme(), (Object)input, this.getIdentifier());
    }

    public TupleEntryCollector openForWrite(FlowProcess<Properties> flowProcess, Object output) throws IOException {
        return new TupleEntrySchemeCollector(flowProcess, this.getScheme(), output);
    }

    public boolean createResource(Properties conf) throws IOException {
        return false;
    }

    public boolean deleteResource(Properties conf) throws IOException {
        return false;
    }

    public boolean resourceExists(Properties conf) throws IOException {
        return true;
    }

    public long getModifiedTime(Properties conf) throws IOException {
        return -1L;
    }
}

