/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeCollector;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeIterator;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.elasticsearch.hadoop.cascading.ESHadoopScheme;

class ESHadoopTap
extends Tap<JobConf, RecordReader, OutputCollector> {
    private String target;

    public ESHadoopTap(String host, int port, String index, Fields fields) {
        this.target = index;
        this.setScheme(new ESHadoopScheme(host, port, index, fields));
    }

    public String getIdentifier() {
        return this.target;
    }

    public TupleEntryIterator openForRead(FlowProcess<JobConf> flowProcess, RecordReader input) throws IOException {
        return new HadoopTupleEntrySchemeIterator(flowProcess, (Tap)this, null);
    }

    public TupleEntryCollector openForWrite(FlowProcess<JobConf> flowProcess, OutputCollector output) throws IOException {
        return new HadoopTupleEntrySchemeCollector(flowProcess, (Tap)this, output);
    }

    public boolean createResource(JobConf conf) throws IOException {
        return false;
    }

    public boolean deleteResource(JobConf conf) throws IOException {
        return false;
    }

    public boolean resourceExists(JobConf conf) throws IOException {
        return true;
    }

    public long getModifiedTime(JobConf conf) throws IOException {
        return 0L;
    }
}

