/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.blobstore.hdfs.HdfsBlobStore;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.gateway.blobstore.BlobStoreGateway;
import org.elasticsearch.gateway.hdfs.HdfsIndexGatewayModule;
import org.elasticsearch.threadpool.ThreadPool;

public class HdfsGateway
extends BlobStoreGateway {
    private final boolean closeFileSystem;
    private final FileSystem fileSystem;
    private final ExecutorService concurrentStreamPool;

    @Inject
    public HdfsGateway(Settings settings, ThreadPool threadPool, ClusterService clusterService, ClusterName clusterName) throws IOException {
        super(settings, threadPool, clusterService);
        this.closeFileSystem = this.componentSettings.getAsBoolean("close_fs", Boolean.valueOf(true));
        String uri = this.componentSettings.get("uri");
        if (uri == null) {
            throw new ElasticSearchIllegalArgumentException("hdfs gateway requires the 'uri' setting to be set");
        }
        String path = this.componentSettings.get("path");
        if (path == null) {
            throw new ElasticSearchIllegalArgumentException("hdfs gateway requires the 'path' path setting to be set");
        }
        Path hPath = new Path(new Path(path), clusterName.value());
        int concurrentStreams = this.componentSettings.getAsInt("concurrent_streams", Integer.valueOf(5));
        this.concurrentStreamPool = EsExecutors.newScalingExecutorService((int)1, (int)concurrentStreams, (long)5L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)EsExecutors.daemonThreadFactory((Settings)settings, (String)"[s3_stream]"));
        this.logger.debug("Using uri [{}], path [{}], concurrent_streams [{}]", new Object[]{uri, hPath, concurrentStreams});
        Configuration conf = new Configuration();
        Settings hdfsSettings = settings.getByPrefix("hdfs.conf.");
        for (Map.Entry entry : hdfsSettings.getAsMap().entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.fileSystem = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        this.initialize(new HdfsBlobStore(settings, this.fileSystem, this.concurrentStreamPool, hPath), clusterName, null);
    }

    public String type() {
        return "hdfs";
    }

    public Class<? extends Module> suggestIndexGateway() {
        return HdfsIndexGatewayModule.class;
    }

    protected void doClose() throws ElasticSearchException {
        super.doClose();
        if (this.closeFileSystem) {
            try {
                this.fileSystem.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.concurrentStreamPool.shutdown();
    }
}

