/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.hdfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGatewaySnapshotFailedException;
import org.elasticsearch.index.gateway.hdfs.HdfsIndexGateway;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.indices.recovery.throttler.RecoveryThrottler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.util.SizeUnit;
import org.elasticsearch.util.SizeValue;
import org.elasticsearch.util.TimeValue;
import org.elasticsearch.util.collect.Lists;
import org.elasticsearch.util.inject.Inject;
import org.elasticsearch.util.io.stream.DataInputStreamInput;
import org.elasticsearch.util.io.stream.DataOutputStreamOutput;
import org.elasticsearch.util.io.stream.StreamInput;
import org.elasticsearch.util.io.stream.StreamOutput;
import org.elasticsearch.util.lucene.Directories;
import org.elasticsearch.util.settings.Settings;

public class HdfsIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private final InternalIndexShard indexShard;
    private final ThreadPool threadPool;
    private final RecoveryThrottler recoveryThrottler;
    private final Store store;
    private final FileSystem fileSystem;
    private final Path path;
    private final Path indexPath;
    private final Path translogPath;
    private volatile FSDataOutputStream currentTranslogStream = null;

    @Inject
    public HdfsIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexGateway hdfsIndexGateway, IndexShard indexShard, Store store, RecoveryThrottler recoveryThrottler) {
        super(shardId, indexSettings);
        this.indexShard = (InternalIndexShard)indexShard;
        this.threadPool = threadPool;
        this.recoveryThrottler = recoveryThrottler;
        this.store = store;
        this.fileSystem = ((HdfsIndexGateway)hdfsIndexGateway).fileSystem();
        this.path = new Path(((HdfsIndexGateway)hdfsIndexGateway).indexPath(), Integer.toString(shardId.id()));
        this.indexPath = new Path(this.path, "index");
        this.translogPath = new Path(this.path, "translog");
    }

    public void close(boolean delete) throws ElasticSearchException {
        if (this.currentTranslogStream != null) {
            try {
                this.currentTranslogStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (delete) {
            try {
                this.fileSystem.delete(this.path, true);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete [{}]", (Throwable)e, new Object[]{this.path});
            }
        }
    }

    public boolean requiresSnapshotScheduling() {
        return true;
    }

    public IndexShardGateway.RecoveryStatus recover() throws IndexShardGatewayRecoveryException {
        IndexShardGateway.RecoveryStatus.Index recoveryStatusIndex = this.recoverIndex();
        IndexShardGateway.RecoveryStatus.Translog recoveryStatusTranslog = this.recoverTranslog();
        return new IndexShardGateway.RecoveryStatus(recoveryStatusIndex, recoveryStatusTranslog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardGateway.SnapshotStatus snapshot(IndexShardGateway.Snapshot snapshot) {
        long totalTimeStart = System.currentTimeMillis();
        boolean indexDirty = false;
        boolean translogDirty = false;
        final SnapshotIndexCommit snapshotIndexCommit = snapshot.indexCommit();
        Translog.Snapshot translogSnapshot = snapshot.translogSnapshot();
        int indexNumberOfFiles = 0;
        long indexTotalFilesSize = 0L;
        long indexTime = 0L;
        if (snapshot.indexChanged()) {
            long time = System.currentTimeMillis();
            indexDirty = true;
            final CountDownLatch latch = new CountDownLatch(snapshotIndexCommit.getFiles().length);
            final AtomicReference<InterruptedException> lastException = new AtomicReference<InterruptedException>();
            for (final String fileName : snapshotIndexCommit.getFiles()) {
                if (fileName.equals(snapshotIndexCommit.getSegmentsFileName())) {
                    latch.countDown();
                    continue;
                }
                IndexInput indexInput = null;
                try {
                    indexInput = snapshotIndexCommit.getDirectory().openInput(fileName);
                    FileStatus fileStatus = this.fileSystem.getFileStatus(new Path(this.indexPath, fileName));
                    if (fileStatus.getLen() == indexInput.length()) {
                        latch.countDown();
                        continue;
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (Exception e) {
                    this.logger.debug("Failed to verify file equality based on length, copying...", (Throwable)e, new Object[0]);
                }
                finally {
                    if (indexInput != null) {
                        try {
                            indexInput.close();
                        }
                        catch (IOException e) {}
                    }
                }
                ++indexNumberOfFiles;
                try {
                    indexTotalFilesSize += snapshotIndexCommit.getDirectory().fileLength(fileName);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.threadPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Path copyTo = new Path(HdfsIndexShardGateway.this.indexPath, fileName);
                        try {
                            FSDataOutputStream fileStream = HdfsIndexShardGateway.this.fileSystem.create(copyTo, true);
                            Directories.copyFromDirectory((Directory)snapshotIndexCommit.getDirectory(), (String)fileName, (OutputStream)fileStream);
                        }
                        catch (Exception e) {
                            lastException.set(new IndexShardGatewaySnapshotFailedException(HdfsIndexShardGateway.this.shardId, "Failed to copy to [" + copyTo + "], from dir [" + snapshotIndexCommit.getDirectory() + "] and file [" + fileName + "]", (Throwable)e));
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                lastException.set(e);
            }
            if (lastException.get() != null) {
                throw new IndexShardGatewaySnapshotFailedException(this.shardId(), "Failed to perform snapshot (index files)", (Throwable)lastException.get());
            }
            indexTime = System.currentTimeMillis() - time;
        }
        int translogNumberOfOperations = 0;
        long translogTime = 0L;
        if (snapshot.newTranslogCreated() || this.currentTranslogStream == null) {
            translogDirty = true;
            long time = System.currentTimeMillis();
            if (this.currentTranslogStream != null) {
                try {
                    this.currentTranslogStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Path currentTranslogPath = new Path(this.translogPath, "translog-" + translogSnapshot.translogId());
            try {
                this.currentTranslogStream = this.fileSystem.create(currentTranslogPath, true);
                DataOutputStreamOutput out = new DataOutputStreamOutput((DataOutput)this.currentTranslogStream);
                for (Translog.Operation operation : translogSnapshot) {
                    ++translogNumberOfOperations;
                    TranslogStreams.writeTranslogOperation((StreamOutput)out, (Translog.Operation)operation);
                }
                this.currentTranslogStream.flush();
                this.currentTranslogStream.sync();
            }
            catch (Exception e) {
                currentTranslogPath = null;
                if (this.currentTranslogStream != null) {
                    try {
                        this.currentTranslogStream.close();
                    }
                    catch (IOException e1) {
                    }
                    finally {
                        this.currentTranslogStream = null;
                    }
                }
                throw new IndexShardGatewaySnapshotFailedException(this.shardId(), "Failed to snapshot translog into [" + currentTranslogPath + "]", (Throwable)e);
            }
            translogTime = System.currentTimeMillis() - time;
        } else if (snapshot.sameTranslogNewOperations()) {
            translogDirty = true;
            long time = System.currentTimeMillis();
            try {
                DataOutputStreamOutput out = new DataOutputStreamOutput((DataOutput)this.currentTranslogStream);
                for (Translog.Operation operation : translogSnapshot.skipTo(snapshot.lastTranslogSize())) {
                    ++translogNumberOfOperations;
                    TranslogStreams.writeTranslogOperation((StreamOutput)out, (Translog.Operation)operation);
                }
            }
            catch (Exception e) {
                try {
                    this.currentTranslogStream.close();
                }
                catch (IOException e1) {
                }
                finally {
                    this.currentTranslogStream = null;
                }
            }
            translogTime = System.currentTimeMillis() - time;
        }
        if (indexDirty) {
            Path segmentsPath = new Path(this.indexPath, snapshotIndexCommit.getSegmentsFileName());
            try {
                ++indexNumberOfFiles;
                indexTotalFilesSize += snapshotIndexCommit.getDirectory().fileLength(snapshotIndexCommit.getSegmentsFileName());
                long time = System.currentTimeMillis();
                FSDataOutputStream fileStream = this.fileSystem.create(segmentsPath, true);
                Directories.copyFromDirectory((Directory)snapshotIndexCommit.getDirectory(), (String)snapshotIndexCommit.getSegmentsFileName(), (OutputStream)fileStream);
                indexTime += System.currentTimeMillis() - time;
            }
            catch (Exception e) {
                throw new IndexShardGatewaySnapshotFailedException(this.shardId(), "Failed to finalize index snapshot into [" + segmentsPath + "]", (Throwable)e);
            }
        }
        if (snapshot.newTranslogCreated()) {
            try {
                this.fileSystem.delete(new Path(this.translogPath, "translog-" + snapshot.lastTranslogId()), false);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (indexDirty) {
            try {
                FileStatus[] existingFiles = this.fileSystem.listStatus(this.indexPath);
                if (existingFiles != null) {
                    for (FileStatus existingFile : existingFiles) {
                        boolean found = false;
                        for (String fileName : snapshotIndexCommit.getFiles()) {
                            if (!existingFile.getPath().getName().equals(fileName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.fileSystem.delete(existingFile.getPath(), false);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new IndexShardGateway.SnapshotStatus(new TimeValue(System.currentTimeMillis() - totalTimeStart), new IndexShardGateway.SnapshotStatus.Index(indexNumberOfFiles, new SizeValue(indexTotalFilesSize), new TimeValue(indexTime)), new IndexShardGateway.SnapshotStatus.Translog(translogNumberOfOperations, new TimeValue(translogTime)));
    }

    private IndexShardGateway.RecoveryStatus.Index recoverIndex() throws IndexShardGatewayRecoveryException {
        FileStatus[] files;
        try {
            files = this.fileSystem.listStatus(this.indexPath);
        }
        catch (IOException e) {
            throw new IndexShardGatewayRecoveryException(this.shardId(), "Failed to list files", (Throwable)e);
        }
        if (files == null || files.length == 0) {
            return new IndexShardGateway.RecoveryStatus.Index(-1L, 0, new SizeValue(0L, SizeUnit.BYTES), TimeValue.timeValueMillis((long)0L));
        }
        final CountDownLatch latch = new CountDownLatch(files.length);
        final AtomicReference<InterruptedException> lastException = new AtomicReference<InterruptedException>();
        final AtomicLong throttlingWaitTime = new AtomicLong();
        for (final FileStatus file : files) {
            this.threadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        long throttlingStartTime = System.currentTimeMillis();
                        while (!HdfsIndexShardGateway.this.recoveryThrottler.tryStream(HdfsIndexShardGateway.this.shardId, file.getPath().getName())) {
                            Thread.sleep(HdfsIndexShardGateway.this.recoveryThrottler.throttleInterval().millis());
                        }
                        throttlingWaitTime.addAndGet(System.currentTimeMillis() - throttlingStartTime);
                        FSDataInputStream fileStream = HdfsIndexShardGateway.this.fileSystem.open(file.getPath());
                        Directories.copyToDirectory((InputStream)fileStream, (Directory)HdfsIndexShardGateway.this.store.directory(), (String)file.getPath().getName());
                    }
                    catch (Exception e) {
                        HdfsIndexShardGateway.this.logger.debug("Failed to read [" + file + "] into [" + HdfsIndexShardGateway.this.store + "]", (Throwable)e, new Object[0]);
                        lastException.set(e);
                    }
                    finally {
                        HdfsIndexShardGateway.this.recoveryThrottler.streamDone(HdfsIndexShardGateway.this.shardId, file.getPath().getName());
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            lastException.set(e);
        }
        if (lastException.get() != null) {
            throw new IndexShardGatewayRecoveryException(this.shardId(), "Failed to recover index files", (Throwable)lastException.get());
        }
        long totalSize = 0L;
        for (FileStatus file : files) {
            totalSize += file.getLen();
        }
        long version = -1L;
        try {
            if (IndexReader.indexExists((Directory)this.store.directory())) {
                version = IndexReader.getCurrentVersion((Directory)this.store.directory());
            }
        }
        catch (IOException e) {
            throw new IndexShardGatewayRecoveryException(this.shardId(), "Failed to fetch index version after copying it over", (Throwable)e);
        }
        return new IndexShardGateway.RecoveryStatus.Index(version, files.length, new SizeValue(totalSize, SizeUnit.BYTES), TimeValue.timeValueMillis((long)throttlingWaitTime.get()));
    }

    private IndexShardGateway.RecoveryStatus.Translog recoverTranslog() throws IndexShardGatewayRecoveryException {
        FSDataInputStream fileStream = null;
        try {
            long recoveryTranslogId = this.findLatestTranslogId();
            if (recoveryTranslogId == -1L) {
                this.indexShard.start();
                IndexShardGateway.RecoveryStatus.Translog translog = new IndexShardGateway.RecoveryStatus.Translog(-1L, 0, new SizeValue(0L, SizeUnit.BYTES));
                return translog;
            }
            FileStatus status = this.fileSystem.getFileStatus(new Path(this.translogPath, "translog-" + recoveryTranslogId));
            fileStream = this.fileSystem.open(status.getPath());
            ArrayList operations = Lists.newArrayList();
            try {
                while (true) {
                    operations.add(TranslogStreams.readTranslogOperation((StreamInput)new DataInputStreamInput((DataInput)fileStream)));
                }
            }
            catch (EOFException e) {
                this.indexShard.performRecovery((Iterable)operations);
                IndexShardGateway.RecoveryStatus.Translog translog = new IndexShardGateway.RecoveryStatus.Translog(recoveryTranslogId, operations.size(), new SizeValue(status.getLen(), SizeUnit.BYTES));
                return translog;
            }
        }
        catch (Exception e) {
            throw new IndexShardGatewayRecoveryException(this.shardId(), "Failed to perform recovery of translog", (Throwable)e);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private long findLatestTranslogId() throws IOException {
        FileStatus[] files = this.fileSystem.listStatus(this.translogPath, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith("translog-");
            }
        });
        if (files == null) {
            return -1L;
        }
        long index = -1L;
        for (FileStatus file : files) {
            String name = file.getPath().getName();
            long fileIndex = Long.parseLong(name.substring(name.indexOf(45) + 1));
            if (fileIndex < index) continue;
            index = fileIndex;
        }
        return index;
    }
}

